/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class OpenFileXmlRpcHandler
implements ApplicationComponent {
    private static final String HANDLER_NAME = "fileOpener";
    private final XmlRpcServer myXmlRpcServer;

    public OpenFileXmlRpcHandler(XmlRpcServer xmlRpcServer) {
        this.myXmlRpcServer = xmlRpcServer;
    }

    @NonNls
    public String getComponentName() {
        return "OpenFileXmlRpcHandler";
    }

    public void initComponent() {
        this.myXmlRpcServer.addHandler(HANDLER_NAME, (Object)new OpenFileHandler());
    }

    public void disposeComponent() {
        this.myXmlRpcServer.removeHandler(HANDLER_NAME);
    }

    public static class OpenFileHandler {
        public boolean open(final String absolutePath) {
            final Application application = ApplicationManager.getApplication();
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                    if (openProjects.length == 0) {
                        return;
                    }
                    Project project = openProjects[0];
                    String correctPath = absolutePath.replace(File.separatorChar, '/');
                    final VirtualFile[] virtualFiles = new VirtualFile[1];
                    final String correctPath1 = correctPath;
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            virtualFiles[0] = LocalFileSystem.getInstance().refreshAndFindFileByPath(correctPath1);
                        }
                    });
                    if (virtualFiles[0] == null) {
                        return;
                    }
                    FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
                    if (editorProviderManager.getProviders(project, virtualFiles[0]).length == 0) {
                        return;
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFiles[0]);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                }
            });
            return true;
        }
    }
}

