/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.history.integration.ui.views.table.ArrowBorder;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ShiftedCellRendererWrapper
extends JPanel
implements TableCellRenderer {
    private TableCellRenderer myDataRenderer;
    private JComponent myRendererComponent;
    private final ArrowBorder myBorder = new ArrowBorder();
    private final Border myEmptyBorder;
    private final JComponent myPrevBottomRenderer = new JPanel();
    private final SideBorder myPrevBottomBorder = new SideBorder(null, 2);

    public ShiftedCellRendererWrapper() {
        super(new BorderLayout());
        Insets insets = this.myBorder.getBorderInsets(this);
        this.myEmptyBorder = BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right);
        this.myPrevBottomRenderer.setBorder((Border)this.myPrevBottomBorder);
    }

    public void setDataRenderer(TableCellRenderer dataRenderer) {
        this.myDataRenderer = dataRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.myRendererComponent != null) {
            this.remove(this.myRendererComponent);
        }
        this.myRendererComponent = null;
        this.myRendererComponent = (JComponent)this.myDataRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.myRendererComponent == null) {
            return null;
        }
        this.myBorder.setColor(table.getGridColor());
        this.setForeground(this.myRendererComponent.getForeground());
        this.setFont(this.myRendererComponent.getFont());
        this.setBorder(this.myBorder);
        if (this.myRendererComponent != null) {
            this.add((Component)this.myRendererComponent, "Center");
        }
        this.setBackground(table.getBackground());
        return this;
    }
}

