/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NumberDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private static final int MILLIS_IN_DAY = 86400000;
    private JTextField myPurgePeriodField;
    private JCheckBox myProjectOpenBox;
    private JCheckBox myOnProjectCompileBox;
    private JCheckBox myOnFileCompileBox;
    private JCheckBox myOnProjectMakeBox;
    private JCheckBox myOnRunningBox;
    private JCheckBox myOnUnitTestsPassedBox;
    private JCheckBox myOnUnitTestsFailedBox;

    public String getDisplayName() {
        return LocalHistoryBundle.message("config.dialog.title", new Object[0]);
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableLocalVCS.png");
    }

    public String getHelpTopic() {
        return "project.propLocalVCS";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public void disposeUIResources() {
    }

    public JComponent createComponent() {
        JPanel controls = new JPanel(new BorderLayout(0, 5));
        controls.add((Component)this.createPurgePeriodPanel(), "North");
        controls.add((Component)this.createLabelingPanel(), "Center");
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)controls, "North");
        panel.add(Box.createVerticalGlue(), "Center");
        return panel;
    }

    private JPanel createPurgePeriodPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myPurgePeriodField = new JTextField();
        JLabel l = new JLabel(LocalHistoryBundle.message("config.period", new Object[0]));
        l.setLabelFor(this.myPurgePeriodField);
        panel.add((Component)l, "Center");
        panel.add((Component)this.myPurgePeriodField, "East");
        Dimension size = new Dimension(50, this.myPurgePeriodField.getPreferredSize().height);
        this.myPurgePeriodField.setPreferredSize(size);
        this.myPurgePeriodField.setDocument((Document)new NumberDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str, a);
                LocalHistoryConfigurable.this.setModified(true);
            }
        });
        return panel;
    }

    private JPanel createLabelingPanel() {
        JPanel panel = new JPanel(new GridLayout(7, 1));
        TitledBorder title = IdeBorderFactory.createTitledBorder((String)LocalHistoryBundle.message("config.put.label.group", new Object[0]));
        panel.setBorder(BorderFactory.createCompoundBorder(title, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.myProjectOpenBox = this.addCheckBox("config.put.label.on.project.opening", panel);
        this.myOnProjectCompileBox = this.addCheckBox("config.put.label.on.project.compilation", panel);
        this.myOnFileCompileBox = this.addCheckBox("config.put.label.on.file.package.compilation", panel);
        this.myOnProjectMakeBox = this.addCheckBox("config.put.label.on.project.make", panel);
        this.myOnRunningBox = this.addCheckBox("config.put.label.on.running.debugging", panel);
        this.myOnUnitTestsPassedBox = this.addCheckBox("config.put.label.on.unit.tests.passed", panel);
        this.myOnUnitTestsFailedBox = this.addCheckBox("config.put.label.on.unit.tests.failed", panel);
        return panel;
    }

    private JCheckBox addCheckBox(String messageKey, JPanel p) {
        final JCheckBox cb = new JCheckBox();
        cb.addChangeListener(new ChangeListener(){
            private boolean myOldValue;
            {
                this.myOldValue = cb.isSelected();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myOldValue != cb.isSelected()) {
                    LocalHistoryConfigurable.this.setModified(true);
                    this.myOldValue = cb.isSelected();
                }
            }
        });
        cb.setText(LocalHistoryBundle.message(messageKey, new Object[0]));
        p.add(cb);
        return cb;
    }

    public void apply() throws ConfigurationException {
        LocalHistoryConfiguration c = this.getConfiguration();
        c.PURGE_PERIOD = Long.parseLong(this.myPurgePeriodField.getText()) * 86400000L;
        c.ADD_LABEL_ON_FILE_PACKAGE_COMPILATION = this.myOnFileCompileBox.isSelected();
        c.ADD_LABEL_ON_PROJECT_COMPILATION = this.myOnProjectCompileBox.isSelected();
        c.ADD_LABEL_ON_PROJECT_MAKE = this.myOnProjectMakeBox.isSelected();
        c.ADD_LABEL_ON_PROJECT_OPEN = this.myProjectOpenBox.isSelected();
        c.ADD_LABEL_ON_RUNNING = this.myOnRunningBox.isSelected();
        c.ADD_LABEL_ON_UNIT_TEST_PASSED = this.myOnUnitTestsPassedBox.isSelected();
        c.ADD_LABEL_ON_UNIT_TEST_FAILED = this.myOnUnitTestsFailedBox.isSelected();
        this.setModified(false);
    }

    public void reset() {
        LocalHistoryConfiguration c = this.getConfiguration();
        this.myPurgePeriodField.setText(String.valueOf(c.PURGE_PERIOD / 86400000L));
        this.myOnFileCompileBox.setSelected(c.ADD_LABEL_ON_FILE_PACKAGE_COMPILATION);
        this.myOnProjectCompileBox.setSelected(c.ADD_LABEL_ON_PROJECT_COMPILATION);
        this.myOnProjectMakeBox.setSelected(c.ADD_LABEL_ON_PROJECT_MAKE);
        this.myProjectOpenBox.setSelected(c.ADD_LABEL_ON_PROJECT_OPEN);
        this.myOnRunningBox.setSelected(c.ADD_LABEL_ON_RUNNING);
        this.myOnUnitTestsPassedBox.setSelected(c.ADD_LABEL_ON_UNIT_TEST_PASSED);
        this.myOnUnitTestsFailedBox.setSelected(c.ADD_LABEL_ON_UNIT_TEST_FAILED);
        this.setModified(false);
    }

    private LocalHistoryConfiguration getConfiguration() {
        return LocalHistoryConfiguration.getInstance();
    }
}

