/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.history.integration.revertion.ChangeReverter;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class HistoryDialogModel {
    protected LocalVcs myVcs;
    protected VirtualFile myFile;
    protected IdeaGateway myGateway;
    private List<Revision> myRevisionsCache;
    private boolean myShowChangesOnly;
    private int myRightRevisionIndex;
    private int myLeftRevisionIndex;
    private boolean myIsChangesSelected = false;

    public HistoryDialogModel(IdeaGateway gw, LocalVcs vcs, VirtualFile f) {
        this.myVcs = vcs;
        this.myFile = f;
        this.myGateway = gw;
    }

    public List<Revision> getRevisions() {
        if (this.myRevisionsCache == null) {
            this.initRevisionsCache();
        }
        return this.myRevisionsCache;
    }

    private void initRevisionsCache() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myRevisionsCache = this.getRevisionsCache();
    }

    protected List<Revision> getRevisionsCache() {
        List<Revision> all = this.myVcs.getRevisionsFor(this.myFile.getPath());
        if (!this.myShowChangesOnly) {
            return all;
        }
        ArrayList<Revision> result = new ArrayList<Revision>();
        for (Revision r : all) {
            if (!r.isImportant()) continue;
            result.add(r);
        }
        if (result.isEmpty()) {
            result.add(all.get(0));
        }
        return result;
    }

    protected Revision getLeftRevision() {
        return this.getRevisions().get(this.myLeftRevisionIndex);
    }

    protected Revision getRightRevision() {
        return this.getRevisions().get(this.myRightRevisionIndex);
    }

    protected Entry getLeftEntry() {
        return this.getLeftRevision().getEntry();
    }

    protected Entry getRightEntry() {
        return this.getRightRevision().getEntry();
    }

    public void selectRevisions(int first, int second) {
        this.doSelect(first, second);
        this.myIsChangesSelected = false;
    }

    public void selectChanges(int first, int second) {
        this.doSelect(first, second + 1);
        this.myIsChangesSelected = true;
    }

    private void doSelect(int first, int second) {
        if (first == second) {
            this.myRightRevisionIndex = 0;
            this.myLeftRevisionIndex = first == -1 ? 0 : first;
        } else {
            this.myRightRevisionIndex = first;
            this.myLeftRevisionIndex = second;
        }
    }

    public void showChangesOnly(boolean value) {
        this.myShowChangesOnly = value;
        this.initRevisionsCache();
        this.resetSelection();
    }

    protected void resetSelection() {
        this.selectRevisions(0, 0);
    }

    public boolean doesShowChangesOnly() {
        return this.myShowChangesOnly;
    }

    protected boolean isCurrentRevisionSelected() {
        return this.myRightRevisionIndex == 0;
    }

    public List<Change> getChanges() {
        List<Difference> dd = this.getLeftRevision().getDifferencesWith(this.getRightRevision());
        ArrayList<Change> result = new ArrayList<Change>();
        for (Difference d : dd) {
            result.add(this.createChange(d));
        }
        return result;
    }

    protected Change createChange(Difference d) {
        return new Change(d.getLeftContentRevision(this.myGateway), d.getRightContentRevision(this.myGateway));
    }

    public void createPatch(String path, boolean isReverse) throws VcsException, IOException {
        PatchCreator.create(this.myGateway, this.getChanges(), path, isReverse);
    }

    public Reverter createReverter() {
        if (this.myIsChangesSelected) {
            return this.createChangeReverter();
        }
        return this.createRevisionReverter();
    }

    protected Reverter createChangeReverter() {
        return new ChangeReverter(this.myVcs, this.myGateway, this.getRightRevision().getCauseChange());
    }

    protected abstract Reverter createRevisionReverter();

    public boolean isRevertEnabled() {
        if (this.myIsChangesSelected) {
            return this.isCorrectChangeSelection();
        }
        return this.isCurrentRevisionSelected() && this.myLeftRevisionIndex > 0;
    }

    public boolean isCreatePatchEnabled() {
        return this.isCorrectSelectionForPatchCreation();
    }

    private boolean isCorrectSelectionForPatchCreation() {
        if (this.myIsChangesSelected) {
            return this.isCorrectChangeSelection();
        }
        return this.myLeftRevisionIndex > 0;
    }

    private boolean isCorrectChangeSelection() {
        return this.myLeftRevisionIndex - this.myRightRevisionIndex == 1;
    }

    public boolean canPerformCreatePatch() {
        return !this.getLeftEntry().hasUnavailableContent() && !this.getRightEntry().hasUnavailableContent();
    }
}

