/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.SelectiveChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.integration.FormatUtil;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.ChangeRevertionVisitor;
import com.intellij.history.integration.revertion.Reverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChangeReverter
extends Reverter {
    private final LocalVcs myVcs;
    private final IdeaGateway myGateway;
    private final Change myChange;
    private List<Change> myChainCache;

    public ChangeReverter(LocalVcs vcs, IdeaGateway gw, Change c) {
        super(vcs, gw);
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myChange = c;
    }

    @Override
    public List<String> askUserForProceeding() throws IOException {
        final ArrayList<String> result = new ArrayList<String>();
        this.myVcs.acceptRead(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c) throws ChangeVisitor.StopVisitingException {
                if (ChangeReverter.this.isBeforeMyChange(c, false)) {
                    this.stop();
                }
                if (!ChangeReverter.this.isInTheChain(c)) {
                    return;
                }
                result.add(LocalHistoryBundle.message("revert.message.have.sequential.changes", new Object[0]));
                this.stop();
            }
        });
        return result;
    }

    @Override
    protected void doCheckCanRevert(final List<String> errors) throws IOException {
        super.doCheckCanRevert(errors);
        this.myVcs.acceptRead(this.selective(new ChangeVisitor(){

            @Override
            public void visit(StructuralChange c) {
                if (!c.canRevertOn(this.myRoot)) {
                    errors.add(LocalHistoryBundle.message("revert.error.files.already.exist", new Object[0]));
                    return;
                }
                c.revertOn(this.myRoot);
            }
        }));
    }

    @Override
    protected String formatCommandName() {
        String name = this.myChange.getName();
        if (name != null) {
            return LocalHistoryBundle.message("system.label.revert.of.change", name);
        }
        String date = FormatUtil.formatTimestamp(this.myChange.getTimestamp());
        return LocalHistoryBundle.message("system.label.revert.of.change.made.at.date", date);
    }

    @Override
    protected void doRevert() throws IOException {
        this.myVcs.acceptWrite(this.selective(new ChangeRevertionVisitor(this.myGateway)));
    }

    @Override
    protected ChangeVisitor selective(ChangeVisitor v) {
        return new SelectiveChangeVisitor(v){

            @Override
            protected boolean isFinished(ChangeSet c) {
                return ChangeReverter.this.isBeforeMyChange(c, true);
            }

            @Override
            protected boolean shouldProcess(StructuralChange c) {
                return ChangeReverter.this.isInTheChain(c);
            }
        };
    }

    private boolean isBeforeMyChange(ChangeSet c, boolean canBeEqual) {
        return !this.myVcs.isBefore(this.myChange, c, canBeEqual);
    }

    private boolean isInTheChain(Change c) {
        if (this.myChainCache == null) {
            this.myChainCache = this.myVcs.getChain(this.myChange);
        }
        return c.affectsSameAs(this.myChainCache);
    }
}

