/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.diagnostic.Diagnostic;
import com.intellij.history.ByteContent;
import com.intellij.history.Clock;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ContentFactory;
import com.intellij.history.core.Paths;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeList;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutEntryLabelChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.revisions.RevisionAfterChange;
import com.intellij.history.core.revisions.RevisionBeforeChange;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Storage;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalVcs {
    private final JBLock myEntriesReadLock;
    private final JBLock myEntriesWriteLock;
    private final JBLock myChangeSetsReadLock;
    private final JBLock myChangeSetsWriteLock;
    protected final Storage myStorage;
    private final List<Listener> myListeners = ContainerUtil.createEmptyCOWList();
    private ChangeList myChangeList;
    private volatile int myEntryCounter;
    private Entry myRoot;
    private boolean wasModifiedAfterLastSave;
    private int myChangeSetDepth;

    public LocalVcs(Storage s) {
        JBReentrantReadWriteLock entriesLock = LockFactory.createReadWriteLock();
        this.myEntriesReadLock = entriesLock.readLock();
        this.myEntriesWriteLock = entriesLock.writeLock();
        JBReentrantReadWriteLock changeSetsLock = LockFactory.createReadWriteLock();
        this.myChangeSetsReadLock = changeSetsLock.readLock();
        this.myChangeSetsWriteLock = changeSetsLock.writeLock();
        this.myStorage = s;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.writeAll();
        try {
            Memento m = this.myStorage.load();
            this.myRoot = m.myRoot;
            this.myEntryCounter = m.myEntryCounter;
            this.myChangeList = m.myChangeList;
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.readAll();
        try {
            if (!this.wasModifiedAfterLastSave) {
                return;
            }
            this.myStorage.saveContents();
            Memento m = new Memento();
            m.myRoot = this.myRoot;
            m.myEntryCounter = this.myEntryCounter;
            m.myChangeList = this.myChangeList;
            this.myStorage.saveState(m);
            this.wasModifiedAfterLastSave = false;
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeObsoleteAndSave(long period) {
        this.writeAll();
        try {
            this.wasModifiedAfterLastSave = true;
            this.purgeObsolete(period);
            this.save();
        }
        finally {
            this.unwriteAll();
        }
    }

    private void purgeObsolete(long period) {
        List<Content> contentsToPurge = this.myChangeList.purgeObsolete(period);
        this.myStorage.purgeContents(contentsToPurge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(String path) {
        this.readEntries();
        try {
            boolean bl = this.myRoot.hasEntry(path);
            return bl;
        }
        finally {
            this.unreadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String path) {
        this.readEntries();
        try {
            Entry entry = this.myRoot.getEntry(path);
            return entry;
        }
        finally {
            this.unreadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry findEntry(String path) {
        this.readEntries();
        try {
            Entry entry = this.myRoot.findEntry(path);
            return entry;
        }
        finally {
            this.unreadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getRoots() {
        this.readEntries();
        try {
            List<Entry> list = this.myRoot.getChildren();
            return list;
        }
        finally {
            this.unreadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginChangeSet() {
        this.writeChanges();
        try {
            this.myChangeList.beginChangeSet();
            ++this.myChangeSetDepth;
        }
        finally {
            this.unwriteChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endChangeSet(String name) {
        this.writeChanges();
        try {
            this.myChangeList.endChangeSet(name);
            --this.myChangeSetDepth;
            if (this.myChangeSetDepth == 0) {
                this.myStorage.saveContents();
            }
        }
        finally {
            this.unwriteChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String path, ContentFactory f, long timestamp, boolean isReadOnly) {
        this.writeAll();
        try {
            this.doCreateFile(this.getNextId(), path, f, timestamp, isReadOnly);
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFile(int id, String path, ContentFactory f, long timestamp, boolean isReadOnly) {
        this.writeAll();
        try {
            this.doCreateFile(id, path, f, timestamp, isReadOnly);
        }
        finally {
            this.unwriteAll();
        }
    }

    private void doCreateFile(int id, String path, ContentFactory f, long timestamp, boolean isReadOnly) {
        String parent = Paths.getParentOf(path);
        if (parent != null && !this.checkEntryExists(parent)) {
            return;
        }
        Content c = this.createContentFrom(f);
        this.applyChange(new CreateFileChange(id, path, c, timestamp, isReadOnly));
    }

    protected Content createContentFrom(ContentFactory f) {
        return f.createContent(this.myStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(String path) {
        this.writeAll();
        try {
            this.doCreateDirectory(this.getNextId(), path);
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDirectory(int id, String path) {
        this.writeAll();
        try {
            this.doCreateDirectory(id, path);
        }
        finally {
            this.unwriteAll();
        }
    }

    private void doCreateDirectory(int id, String path) {
        this.applyChange(new CreateDirectoryChange(id, path));
    }

    private int getNextId() {
        return this.myEntryCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeFileContent(String path, ContentFactory f, long timestamp) {
        this.writeAll();
        try {
            if (!this.checkEntryExists(path)) {
                return;
            }
            if (this.contentWasNotChanged(path, f)) {
                return;
            }
            Content c = this.createContentFrom(f);
            this.applyChange(new ContentChange(path, c, timestamp));
        }
        finally {
            this.unwriteAll();
        }
    }

    private boolean checkEntryExists(String path) {
        if (!Diagnostic.isJavaAssertionsEnabled()) {
            return true;
        }
        if (this.findEntry(path) != null) {
            return true;
        }
        LocalHistoryLog.LOG.warn("Entry not found: " + path);
        return false;
    }

    protected boolean contentWasNotChanged(String path, ContentFactory f) {
        return f.equalsTo(this.getEntry(path).getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String path, String newName) {
        this.writeAll();
        try {
            this.applyChange(new RenameChange(path, newName));
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeROStatus(String path, boolean isReadOnly) {
        this.writeAll();
        try {
            this.applyChange(new ROStatusChange(path, isReadOnly));
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String path, String newParentPath) {
        this.writeAll();
        try {
            this.applyChange(new MoveChange(path, newParentPath));
        }
        finally {
            this.unwriteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        this.writeAll();
        try {
            this.applyChange(new DeleteChange(path));
        }
        finally {
            this.unwriteAll();
        }
    }

    public Label putSystemLabel(String name, int color) {
        return this.applyLabel(new PutSystemLabelChange(name, color, this.getCurrentTimestamp()));
    }

    public Label putUserLabel(String name) {
        return this.applyLabel(new PutLabelChange(name, this.getCurrentTimestamp()));
    }

    public Label putUserLabel(String path, String name) {
        return this.applyLabel(new PutEntryLabelChange(path, name, this.getCurrentTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Label applyLabel(final PutLabelChange c) {
        this.writeAll();
        try {
            c.applyTo(this.myRoot);
            this.addChangeToChangeList(c);
            Label label = new Label(){

                public ByteContent getByteContent(String path) {
                    return LocalVcs.this.getByteContentBefore(path, c);
                }
            };
            return label;
        }
        finally {
            this.unwriteAll();
        }
    }

    private void applyChange(Change c) {
        c.applyTo(this.myRoot);
        this.beginChangeSet();
        this.addChangeToChangeList(c);
        this.endChangeSet(null);
        this.fireChange(c);
    }

    private void addChangeToChangeList(Change c) {
        this.myChangeList.addChange(c);
        this.wasModifiedAfterLastSave = true;
    }

    public ChangeList getChangeList() {
        return this.myChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBefore(Change before, Change after, boolean canBeEqual) {
        this.readChangeSets();
        try {
            boolean bl = this.myChangeList.isBefore(before, after, canBeEqual);
            return bl;
        }
        finally {
            this.unreadChangeSets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Change> getChain(Change initialChange) {
        this.readChangeSets();
        try {
            List<Change> list = this.myChangeList.getChain(initialChange);
            return list;
        }
        finally {
            this.unreadChangeSets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteContent getByteContentBefore(String path, Change change) {
        this.readAll();
        try {
            RevisionAfterChange revision = new RevisionAfterChange(this.myRoot, this.myRoot, this.myChangeList, change);
            Entry entry = ((Revision)revision).getEntry().findEntry(path);
            if (entry == null) {
                ByteContent byteContent = new ByteContent(false, null);
                return byteContent;
            }
            if (entry.isDirectory()) {
                ByteContent byteContent = new ByteContent(true, null);
                return byteContent;
            }
            ByteContent byteContent = new ByteContent(false, entry.getContent().getBytesIfAvailable());
            return byteContent;
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Revision> getRevisionsFor(String path) {
        this.readAll();
        try {
            List<Revision> list = new RevisionsCollector(this, path, this.myRoot, this.myChangeList).getResult();
            return list;
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteContent(String path, FileRevisionTimestampComparator c) {
        this.readAll();
        try {
            byte[] byArray = new ByteContentRetriever(this, path, c).getResult();
            return byArray;
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecentChange> getRecentChanges() {
        this.readAll();
        try {
            ArrayList<RecentChange> result = new ArrayList<RecentChange>();
            List<Change> cc = this.myChangeList.getChanges();
            for (int i = 0; i < cc.size() && result.size() < 20; ++i) {
                Change c = cc.get(i);
                if (c.isFileContentChange() || c.isLabel() || c.getName() == null) continue;
                RevisionBeforeChange before = new RevisionBeforeChange(this.myRoot, this.myRoot, this.myChangeList, c);
                RevisionAfterChange after = new RevisionAfterChange(this.myRoot, this.myRoot, this.myChangeList, c);
                result.add(new RecentChange(before, after));
            }
            ArrayList<RecentChange> arrayList = result;
            return arrayList;
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptRead(ChangeVisitor v) throws IOException {
        this.readAll();
        try {
            this.myChangeList.getAcceptFunc(this.myRoot, v, false).doAccept();
        }
        finally {
            this.unreadAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptWrite(ChangeVisitor v) throws IOException {
        ChangeList.AcceptFun acceptFun;
        this.readAll();
        try {
            acceptFun = this.myChangeList.getAcceptFunc(this.myRoot, v, true);
        }
        finally {
            this.unreadAll();
        }
        acceptFun.doAccept();
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.add(l);
    }

    private void fireChange(Change c) {
        for (Listener each : this.myListeners) {
            each.onChange(c);
        }
    }

    private long getCurrentTimestamp() {
        return Clock.getCurrentTimestamp();
    }

    private void writeChanges() {
        this.myChangeSetsWriteLock.lock();
    }

    private void unwriteChanges() {
        this.myChangeSetsWriteLock.unlock();
    }

    private void readChangeSets() {
        this.myChangeSetsReadLock.lock();
    }

    private void unreadChangeSets() {
        this.myChangeSetsReadLock.unlock();
    }

    private void writeEntries() {
        this.myEntriesWriteLock.lock();
    }

    private void unwriteEntries() {
        this.myEntriesWriteLock.unlock();
    }

    private void readEntries() {
        this.myEntriesReadLock.lock();
    }

    private void unreadEntries() {
        this.myEntriesReadLock.unlock();
    }

    private void readAll() {
        this.readEntries();
        this.readChangeSets();
    }

    private void unreadAll() {
        this.unreadEntries();
        this.unreadChangeSets();
    }

    private void writeAll() {
        this.writeEntries();
        this.writeChanges();
    }

    private void unwriteAll() {
        this.unwriteEntries();
        this.unwriteChanges();
    }

    public static interface Listener {
        public void onChange(Change var1);
    }

    public static class Memento {
        public Entry myRoot = new RootEntry();
        public int myEntryCounter = 0;
        public ChangeList myChangeList = new ChangeList();
    }
}

