/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.replaceInProject;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ReplaceInProjectManager {
    private final Project myProject;
    private boolean myIsFindInProgress = false;

    public static ReplaceInProjectManager getInstance(Project project) {
        return (ReplaceInProjectManager)ServiceManager.getService((Project)project, ReplaceInProjectManager.class);
    }

    public ReplaceInProjectManager(Project project) {
        this.myProject = project;
    }

    public void replaceInProject(DataContext dataContext) {
        String s;
        final FindManager findManager = FindManager.getInstance((Project)this.myProject);
        final FindModel findModel = (FindModel)findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(true);
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (s = editor.getSelectionModel().getSelectedText()) != null && !s.contains("\r") && !s.contains("\n")) {
            findModel.setStringToFind(s);
        }
        findManager.showFindDialog(findModel, new Runnable(){

            @Override
            public void run() {
                final PsiDirectory psiDirectory = FindInProjectUtil.getPsiDirectory(findModel, ReplaceInProjectManager.this.myProject);
                if (!findModel.isProjectScope() && psiDirectory == null && findModel.getModuleName() == null && findModel.getCustomScope() == null) {
                    return;
                }
                UsageViewManager manager = UsageViewManager.getInstance((Project)ReplaceInProjectManager.this.myProject);
                if (manager == null) {
                    return;
                }
                findManager.getFindInProjectModel().copyFrom(findModel);
                final FindModel findModelCopy = (FindModel)findModel.clone();
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(true, findModelCopy);
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(ReplaceInProjectManager.this.myProject, true, presentation);
                final ReplaceContext[] context = new ReplaceContext[1];
                manager.searchAndShowUsages(new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(findModelCopy.getStringToFind())}, (Factory)new Factory<UsageSearcher>(){

                    public UsageSearcher create() {
                        return new UsageSearcher(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void generate(Processor<Usage> processor) {
                                try {
                                    ReplaceInProjectManager.this.myIsFindInProgress = true;
                                    FindInProjectUtil.findUsages(findModelCopy, psiDirectory, ReplaceInProjectManager.this.myProject, (Processor<UsageInfo>)new AdapterProcessor(processor, (Function)UsageInfo2UsageAdapter.CONVERTER));
                                }
                                finally {
                                    ReplaceInProjectManager.this.myIsFindInProgress = false;
                                }
                            }
                        };
                    }
                }, processPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

                    public void usageViewCreated(UsageView usageView) {
                        context[0] = new ReplaceContext(usageView, findModelCopy);
                        ReplaceInProjectManager.this.addReplaceActions(context[0]);
                    }

                    public void findingUsagesFinished(UsageView usageView) {
                        if (context[0] != null && findManager.getFindInProjectModel().isPromptOnReplace()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ReplaceInProjectManager.this.replaceWithPrompt(context[0]);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void replaceWithPrompt(final ReplaceContext replaceContext) {
        final List _usages = replaceContext.getUsageView().getSortedUsages();
        if (FindInProjectUtil.hasReadOnlyUsages(_usages)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(FindBundle.message("find.replace.occurrences.found.in.read.only.files.status", new Object[0]));
            return;
        }
        final Usage[] usages = _usages.toArray(new Usage[_usages.size()]);
        for (int i = 0; i < usages.length; ++i) {
            PsiFile psiFile;
            final Usage usage = usages[i];
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            PsiElement elt = usageInfo.getElement();
            if (elt == null || !(psiFile = elt.getContainingFile()).isWritable()) continue;
            Runnable selectOnEditorRunnable = new Runnable(){

                @Override
                public void run() {
                    final VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null && ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            return virtualFile.isValid() ? Boolean.TRUE : Boolean.FALSE;
                        }
                    })).booleanValue() && usage.isValid()) {
                        usage.highlightInEditor();
                        replaceContext.getUsageView().selectUsages(new Usage[]{usage});
                    }
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, selectOnEditorRunnable, FindBundle.message("find.replace.select.on.editor.command", new Object[0]), null);
            String title = FindBundle.message("find.replace.found.usage.title", i + 1, usages.length);
            int result = FindManager.getInstance((Project)this.myProject).showPromptDialog(replaceContext.getFindModel(), title);
            if (result == 1) {
                return;
            }
            if (result == 2) continue;
            final int currentNumber = i;
            if (result == 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ReplaceInProjectManager.this.doReplace(replaceContext, usage);
                        replaceContext.getUsageView().removeUsage(usage);
                    }
                };
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable, FindBundle.message("find.replace.command", new Object[0]), null);
                if (i + 1 == usages.length) {
                    replaceContext.getUsageView().close();
                    return;
                }
            }
            if (result == 4) {
                final int[] nextNumber = new int[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        int j;
                        for (j = currentNumber; j < usages.length; ++j) {
                            Usage usage = usages[j];
                            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
                            PsiElement elt = usageInfo.getElement();
                            if (elt == null) continue;
                            PsiFile otherPsiFile = elt.getContainingFile();
                            if (!otherPsiFile.equals(psiFile)) break;
                            ReplaceInProjectManager.this.doReplace(replaceContext, usage);
                            replaceContext.getUsageView().removeUsage(usage);
                        }
                        if (j == usages.length) {
                            replaceContext.getUsageView().close();
                        }
                        nextNumber[0] = j;
                    }
                };
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable, FindBundle.message("find.replace.command", new Object[0]), null);
                i = nextNumber[0] - 1;
            }
            if (result != 5) continue;
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ReplaceInProjectManager.this.doReplace(replaceContext, _usages);
                    replaceContext.getUsageView().close();
                }
            }, FindBundle.message("find.replace.command", new Object[0]), null);
            break;
        }
    }

    private void addReplaceActions(final ReplaceContext replaceContext) {
        Runnable replaceRunnable = new Runnable(){

            @Override
            public void run() {
                ReplaceInProjectManager.this.doReplace(replaceContext, replaceContext.getUsageView().getUsages());
            }
        };
        replaceContext.getUsageView().addPerformOperationAction(replaceRunnable, FindBundle.message("find.replace.all.action", new Object[0]), null, FindBundle.message("find.replace.all.action.description", new Object[0]));
        Runnable replaceSelectedRunnable = new Runnable(){

            @Override
            public void run() {
                ReplaceInProjectManager.this.doReplaceSelected(replaceContext);
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane(replaceSelectedRunnable, FindBundle.message("find.replace.selected.action", new Object[0]));
    }

    private void doReplace(ReplaceContext replaceContext, Collection<Usage> usages) {
        for (Usage usage : usages) {
            this.doReplace(replaceContext, usage);
        }
        ReplaceInProjectManager.reportNumberReplacedOccurences(this.myProject, usages.size());
    }

    public static void reportNumberReplacedOccurences(Project project, int occurrences) {
        if (occurrences != 0) {
            WindowManager.getInstance().getStatusBar(project).setInfo(FindBundle.message("0.occurrences.replaced", occurrences));
        }
    }

    private void doReplace(final ReplaceContext replaceContext, final Usage usage) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (replaceContext.getExcludedSet().contains(usage)) {
                    return;
                }
                List markers = ((UsageInfo2UsageAdapter)usage).getRangeMarkers();
                for (RangeMarker marker : markers) {
                    Document document = marker.getDocument();
                    if (!document.isWritable()) {
                        return;
                    }
                    int textOffset = marker.getStartOffset();
                    if (textOffset < 0 || textOffset >= document.getTextLength()) {
                        return;
                    }
                    int textEndOffset = marker.getEndOffset();
                    if (textEndOffset < 0 || textOffset > document.getTextLength()) {
                        return;
                    }
                    FindManager findManager = FindManager.getInstance((Project)ReplaceInProjectManager.this.myProject);
                    CharSequence foundString = document.getCharsSequence().subSequence(textOffset, textEndOffset);
                    FindResult findResult = findManager.findString(document.getCharsSequence(), textOffset, replaceContext.getFindModel());
                    if (!findResult.isStringFound()) {
                        return;
                    }
                    String stringToReplace = findManager.getStringToReplace(((Object)foundString).toString(), replaceContext.getFindModel(), textOffset, document.getText());
                    if (stringToReplace == null) continue;
                    document.replaceString(textOffset, textEndOffset, (CharSequence)stringToReplace);
                }
            }
        });
    }

    private void doReplaceSelected(final ReplaceContext replaceContext) {
        int result;
        final Set selectedUsages = replaceContext.getUsageView().getSelectedUsages();
        if (selectedUsages == null) {
            return;
        }
        HashSet<VirtualFile> readOnlyFiles = null;
        for (Usage usage : selectedUsages) {
            VirtualFile file = ((UsageInFile)usage).getFile();
            if (file.isWritable()) continue;
            if (readOnlyFiles == null) {
                readOnlyFiles = new HashSet<VirtualFile>();
            }
            readOnlyFiles.add(file);
        }
        if (readOnlyFiles != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(VfsUtil.toVirtualFileArray(readOnlyFiles));
        }
        if (FindInProjectUtil.hasReadOnlyUsages(selectedUsages) && (result = Messages.showOkCancelDialog((Component)replaceContext.getUsageView().getComponent(), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.prompt", new Object[0]), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.title", new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ReplaceInProjectManager.this.doReplace(replaceContext, selectedUsages);
                for (Usage selectedUsage : selectedUsages) {
                    replaceContext.getUsageView().removeUsage(selectedUsage);
                }
                if (replaceContext.getUsageView().getUsages().isEmpty()) {
                    replaceContext.getUsageView().close();
                    return;
                }
                replaceContext.getUsageView().getComponent().requestFocus();
            }
        }, FindBundle.message("find.replace.command", new Object[0]), null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !FindInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    static class ReplaceContext {
        private final UsageView usageView;
        private final FindModel findModel;
        private Set<Usage> excludedSet;

        ReplaceContext(@NotNull UsageView usageView, @NotNull FindModel findModel) {
            if (usageView == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext.<init> must not be null");
            }
            if (findModel == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext.<init> must not be null");
            }
            this.usageView = usageView;
            this.findModel = findModel;
        }

        @NotNull
        public FindModel getFindModel() {
            FindModel findModel = this.findModel;
            if (findModel == null) {
                throw new IllegalStateException("@NotNull method com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext.getFindModel must not return null");
            }
            return findModel;
        }

        @NotNull
        public UsageView getUsageView() {
            UsageView usageView = this.usageView;
            if (usageView == null) {
                throw new IllegalStateException("@NotNull method com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext.getUsageView must not return null");
            }
            return usageView;
        }

        @NotNull
        public Set<Usage> getExcludedSet() {
            if (this.excludedSet == null) {
                this.excludedSet = this.usageView.getExcludedUsages();
            }
            Set<Usage> set = this.excludedSet;
            if (set == null) {
                throw new IllegalStateException("@NotNull method com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext.getExcludedSet must not return null");
            }
            return set;
        }
    }
}

