/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FindClassUsagesDialog
extends JavaFindUsagesDialog {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbMethodsUsages;
    private StateRestoringCheckBox myCbFieldsUsages;
    private StateRestoringCheckBox myCbImplementingClasses;
    private StateRestoringCheckBox myCbDerivedInterfaces;
    private StateRestoringCheckBox myCbDerivedClasses;

    public FindClassUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Override
    public JComponent getPreferredFocusedControl() {
        return this.myCbUsages;
    }

    @Override
    public void calcFindUsagesOptions(FindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        if (FindClassUsagesDialog.isToChange(this.myCbUsages)) {
            options.isUsages = FindClassUsagesDialog.isSelected(this.myCbUsages);
        }
        if (FindClassUsagesDialog.isToChange(this.myCbMethodsUsages)) {
            options.isMethodsUsages = FindClassUsagesDialog.isSelected(this.myCbMethodsUsages);
        }
        if (FindClassUsagesDialog.isToChange(this.myCbFieldsUsages)) {
            options.isFieldsUsages = FindClassUsagesDialog.isSelected(this.myCbFieldsUsages);
        }
        if (FindClassUsagesDialog.isToChange(this.myCbDerivedClasses)) {
            options.isDerivedClasses = FindClassUsagesDialog.isSelected(this.myCbDerivedClasses);
        }
        if (FindClassUsagesDialog.isToChange(this.myCbImplementingClasses)) {
            options.isImplementingClasses = FindClassUsagesDialog.isSelected(this.myCbImplementingClasses);
        }
        if (FindClassUsagesDialog.isToChange(this.myCbDerivedInterfaces)) {
            options.isDerivedInterfaces = FindClassUsagesDialog.isSelected(this.myCbDerivedInterfaces);
        }
        options.isSkipImportStatements = false;
        options.isCheckDeepInheritance = true;
        options.isIncludeInherited = false;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.what.group", new Object[0])));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message("find.what.usages.checkbox", new Object[0]), this.myFindUsagesOptions.isUsages, findWhatPanel, true);
        PsiClass psiClass = (PsiClass)this.getPsiElement();
        this.myCbMethodsUsages = this.addCheckboxToPanel(FindBundle.message("find.what.methods.usages.checkbox", new Object[0]), this.myFindUsagesOptions.isMethodsUsages, findWhatPanel, true);
        if (!psiClass.isAnnotationType()) {
            this.myCbFieldsUsages = this.addCheckboxToPanel(FindBundle.message("find.what.fields.usages.checkbox", new Object[0]), this.myFindUsagesOptions.isFieldsUsages, findWhatPanel, true);
            if (psiClass.isInterface()) {
                this.myCbImplementingClasses = this.addCheckboxToPanel(FindBundle.message("find.what.implementing.classes.checkbox", new Object[0]), this.myFindUsagesOptions.isImplementingClasses, findWhatPanel, true);
                this.myCbDerivedInterfaces = this.addCheckboxToPanel(FindBundle.message("find.what.derived.interfaces.checkbox", new Object[0]), this.myFindUsagesOptions.isDerivedInterfaces, findWhatPanel, true);
            } else if (!psiClass.hasModifierProperty("final")) {
                this.myCbDerivedClasses = this.addCheckboxToPanel(FindBundle.message("find.what.derived.classes.checkbox", new Object[0]), this.myFindUsagesOptions.isDerivedClasses, findWhatPanel, true);
            }
        }
        return findWhatPanel;
    }

    @Override
    protected void update() {
        if (this.myCbToSearchForTextOccurences != null) {
            if (FindClassUsagesDialog.isSelected(this.myCbUsages)) {
                this.myCbToSearchForTextOccurences.makeSelectable();
            } else {
                this.myCbToSearchForTextOccurences.makeUnselectable(false);
            }
        }
        boolean hasSelected = FindClassUsagesDialog.isSelected(this.myCbUsages) || FindClassUsagesDialog.isSelected(this.myCbFieldsUsages) || FindClassUsagesDialog.isSelected(this.myCbMethodsUsages) || FindClassUsagesDialog.isSelected(this.myCbImplementingClasses) || FindClassUsagesDialog.isSelected(this.myCbDerivedInterfaces) || FindClassUsagesDialog.isSelected(this.myCbDerivedClasses);
        this.setOKActionEnabled(hasSelected);
    }
}

