/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CommonFindUsagesDialog
extends AbstractFindUsagesDialog {
    private final PsiElement myPsiElement;

    public CommonFindUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, CommonFindUsagesDialog.isTextSearch(element, isSingleFile, handler), !isSingleFile && !element.getManager().isInProject(element));
        this.myPsiElement = element;
        this.init();
    }

    private static boolean isTextSearch(PsiElement element, boolean isSingleFile, FindUsagesHandler handler) {
        return FindUsagesUtil.isSearchForTextOccurencesAvailable(element, isSingleFile, handler);
    }

    @Override
    protected boolean isInFileOnly() {
        return super.isInFileOnly() || this.myPsiElement != null && this.myPsiElement.getManager().getSearchHelper().getUseScope(this.myPsiElement) instanceof LocalSearchScope;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        return null;
    }

    @Override
    protected JComponent getPreferredFocusedControl() {
        return null;
    }

    @Override
    public String getLabelText() {
        return StringUtil.capitalize((String)UsageViewUtil.getType(this.myPsiElement)) + " " + UsageViewUtil.getDescriptiveName(this.myPsiElement);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(FindUsagesManager.getHelpID(this.myPsiElement));
    }
}

