/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.FacetType;
import com.intellij.facet.autodetecting.DetectedFacetPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDetectedFacetPresentation
extends DetectedFacetPresentation {
    public static final DefaultDetectedFacetPresentation INSTANCE = new DefaultDetectedFacetPresentation();

    @Nullable
    public String getDetectedFacetDescription(VirtualFile root, VirtualFile[] files) {
        VirtualFile file = files[0];
        if (root == null) {
            return file.getPresentableUrl();
        }
        String path = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
        return path != null ? path : file.getPresentableUrl();
    }

    public String getAutodetectionPopupText(@NotNull Module module, @NotNull FacetType facetType, @NotNull String facetName, @NotNull VirtualFile[] files) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DefaultDetectedFacetPresentation.getAutodetectionPopupText must not be null");
        }
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DefaultDetectedFacetPresentation.getAutodetectionPopupText must not be null");
        }
        if (facetName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DefaultDetectedFacetPresentation.getAutodetectionPopupText must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DefaultDetectedFacetPresentation.getAutodetectionPopupText must not be null");
        }
        String fileUrl = DefaultDetectedFacetPresentation.getRelativeFileUrl(files[0], module.getProject());
        return ProjectBundle.message((String)"facet.autodetected.popup.default.text", (Object[])new Object[]{fileUrl, module.getName(), facetType.getPresentableName(), facetName});
    }

    private static String getRelativeFileUrl(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DefaultDetectedFacetPresentation.getRelativeFileUrl must not be null");
        }
        String fileUrl = file.getPresentableUrl();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileUrl;
        }
        String prefix = baseDir.getPresentableUrl() + File.separator;
        if (fileUrl.startsWith(prefix)) {
            return fileUrl.substring(prefix.length());
        }
        return fileUrl;
    }
}

