/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    private volatile T myStub;
    private volatile ASTNode myNode;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/StubBasedPsiElementBase.<init> must not be null");
        }
        if (nodeType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/StubBasedPsiElementBase.<init> must not be null");
        }
        this.myStub = stub;
        this.myElementType = nodeType;
        this.myNode = null;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/StubBasedPsiElementBase.<init> must not be null");
        }
        this.myNode = node;
        this.myElementType = node.getElementType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ASTNode getNode() {
        ASTNode node = this.myNode;
        if (node == null) {
            PsiFileImpl file = (PsiFileImpl)this.getContainingFile();
            Object object = file.getStubLock();
            synchronized (object) {
                node = this.myNode;
                if (node == null) {
                    NonCancelableSection criticalSection = ProgressManager.getInstance().startNonCancelableSection();
                    try {
                        if (!file.isValid()) {
                            throw new PsiInvalidElementAccessException((PsiElement)this);
                        }
                        assert (file.getTreeElement() == null);
                        StubTree stubTree = file.getStubTree();
                        FileElement fileElement = file.loadTreeElement();
                        node = this.myNode;
                        if (node == null) {
                            String message = "failed to bind stub to AST for element " + ((Object)((Object)this)).getClass() + " in " + (file.getVirtualFile() == null ? "<unknown file>" : file.getVirtualFile().getPath()) + "\nFile stub tree:\n" + (stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : " is null") + "\nLoaded file AST:\n" + DebugUtil.treeToString(fileElement, true);
                            throw new IllegalArgumentException(message);
                        }
                    }
                    finally {
                        criticalSection.done();
                    }
                }
            }
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/StubBasedPsiElementBase.getNode must not return null");
        }
        return aSTNode;
    }

    public void setNode(ASTNode node) {
        this.myNode = node;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/StubBasedPsiElementBase.getLanguage must not return null");
        }
        return language;
    }

    @Override
    public PsiFile getContainingFile() {
        Object stub = this.myStub;
        if (stub != null) {
            while (!(stub instanceof PsiFileStub)) {
                stub = stub.getParentStub();
            }
            return (PsiFile)((PsiFileStub)stub).getPsi();
        }
        return super.getContainingFile();
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        T stub = this.myStub;
        if (stub != null) {
            if (stub instanceof PsiFileStub) {
                return stub.getPsi().isValid();
            }
            return stub.getParentStub().getPsi().isValid();
        }
        return super.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getContainingFile().getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/StubBasedPsiElementBase.getProject must not return null");
        }
        return project;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.myStub;
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.setStub(null);
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this.getNode());
    }

    @NotNull
    public IStubElementType getElementType() {
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/StubBasedPsiElementBase.getElementType must not return null");
        }
        return iStubElementType;
    }

    public T getStub() {
        ProgressManager.checkCanceled();
        return this.myStub;
    }

    public void setStub(T stub) {
        this.myStub = stub;
    }

    @Nullable
    public <Stub extends StubElement, Psi extends PsiElement> Psi getStubOrPsiChild(IStubElementType<Stub, Psi> elementType) {
        T stub = this.myStub;
        if (stub != null) {
            StubElement element = stub.findChildStubByType(elementType);
            if (element != null) {
                return (Psi)element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <Stub extends StubElement, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(IStubElementType<Stub, Psi> elementType) {
        Psi result = this.getStubOrPsiChild(elementType);
        assert (result != null) : "Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString((PsiElement)this, false);
        Psi Psi = result;
        if (Psi == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/StubBasedPsiElementBase.getRequiredStubOrPsiChild must not return null");
        }
        return Psi;
    }

    public <Stub extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(IStubElementType<Stub, Psi> elementType, Psi[] array) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(elementType, array);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <Stub extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(IStubElementType<Stub, Psi> elementType, ArrayFactory<Psi> f) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(elementType, f);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(TokenSet filter, Psi[] array) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(filter, array);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(TokenSet filter, ArrayFactory<Psi> f) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(filter, f);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(Class<E> parentClass) {
        T stub = this.myStub;
        if (stub != null) {
            return (E)stub.getParentStubOfType(parentClass);
        }
        return (E)PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    protected Object clone() {
        StubBasedPsiElementBase stubbless = (StubBasedPsiElementBase)((Object)super.clone());
        stubbless.myStub = null;
        return stubbless;
    }
}

