/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.Icon;

public abstract class TestsProgressAnimator
implements Runnable,
Disposable {
    private static final int FRAMES_COUNT = 8;
    private static final int MOVIE_TIME = 800;
    private static final int FRAME_TIME = 100;
    public static final Icon PAUSED_ICON = TestsUIUtil.loadIcon("testPaused");
    public static final Icon[] FRAMES = new Icon[8];
    private long myLastInvocationTime = -1L;
    private Alarm myAlarm;
    private AbstractTestProxy myCurrentTestCase;
    private AbstractTestTreeBuilder myTreeBuilder;

    protected TestsProgressAnimator(Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 800L / 100L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[TestsProgressAnimator.getCurrentFrameIndex()];
    }

    protected void init(AbstractTestTreeBuilder treeBuilder) {
        this.myAlarm = new Alarm();
        this.myTreeBuilder = treeBuilder;
    }

    public AbstractTestProxy getCurrentTestCase() {
        return this.myCurrentTestCase;
    }

    @Override
    public void run() {
        long time;
        if (this.myCurrentTestCase != null && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 100L) {
            this.repaintSubTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void setCurrentTestCase(AbstractTestProxy currentTestCase) {
        this.myCurrentTestCase = currentTestCase;
        this.scheduleRepaint();
    }

    public void stopMovie() {
        if (this.myCurrentTestCase != null) {
            this.repaintSubTree();
        }
        this.setCurrentTestCase(null);
        this.cancelAlarm();
    }

    public void dispose() {
        this.myTreeBuilder = null;
        this.myCurrentTestCase = null;
        this.cancelAlarm();
    }

    private void cancelAlarm() {
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm = null;
        }
    }

    private void repaintSubTree() {
        this.myTreeBuilder.repaintWithParents(this.myCurrentTestCase);
    }

    private void scheduleRepaint() {
        if (this.myAlarm == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentTestCase != null) {
            this.myAlarm.addRequest((Runnable)this, 100);
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            TestsProgressAnimator.FRAMES[i] = TestsUIUtil.loadIcon("testInProgress" + (i + 1));
        }
    }
}

