/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailedState
extends AbstractState {
    private final String myPresentationText;

    public TestFailedState(@Nullable String localizedMessage, @Nullable String stackTrace) {
        this.myPresentationText = TestFailedState.buildErrorPresentationText(localizedMessage, stackTrace);
    }

    @Nullable
    public static String buildErrorPresentationText(@Nullable String localizedMessage, @Nullable String stackTrace) {
        String text = (StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage + "\n") + (StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace + "\n");
        return StringUtil.isEmptyOrSpaces((String)text) ? null : text;
    }

    public static void printError(@NotNull Printer printer, @NotNull String errorPresentationText) {
        if (printer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/states/TestFailedState.printError must not be null");
        }
        if (errorPresentationText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/states/TestFailedState.printError must not be null");
        }
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.mark();
        printer.print(errorPresentationText, ConsoleViewContentType.ERROR_OUTPUT);
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        if (this.myPresentationText != null) {
            TestFailedState.printError(printer, this.myPresentationText);
        }
    }

    @Override
    public boolean isDefect() {
        return true;
    }

    @Override
    public boolean wasLaunched() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isInProgress() {
        return false;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }

    @Override
    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.FAILED_INDEX;
    }

    public String toString() {
        return "TEST FAILED";
    }
}

