/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import org.jetbrains.annotations.NonNls;

public abstract class SuiteFinishedState
extends AbstractState {
    @NonNls
    private static final String EMPTY_SUITE_TEXT = SMTestsRunnerBundle.message("sm.test.runner.states.suite.is.empty", new Object[0]);
    public static SuiteFinishedState PASSED_SUITE = new SuiteFinishedState(){

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.PASSED_INDEX;
        }

        public String toString() {
            return "SUITE PASSED";
        }
    };
    public static SuiteFinishedState FAILED_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.FAILED_INDEX;
        }

        public String toString() {
            return "FAILED SUITE";
        }
    };
    public static SuiteFinishedState WITH_IGNORED_TESTS_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.IGNORED_INDEX;
        }

        public String toString() {
            return "WITH IGNORED TESTS SUITE";
        }
    };
    public static SuiteFinishedState ERROR_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.ERROR_INDEX;
        }

        public String toString() {
            return "ERROR SUITE";
        }
    };
    public static SuiteFinishedState EMPTY_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return false;
        }

        @Override
        public void printOn(Printer printer) {
            super.printOn(printer);
            String msg = EMPTY_SUITE_TEXT + "\n";
            printer.print(msg, ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.COMPLETE_INDEX;
        }

        public String toString() {
            return "EMPTY FINISHED SUITE";
        }
    };

    private SuiteFinishedState() {
    }

    @Override
    public boolean isInProgress() {
        return false;
    }

    @Override
    public boolean isDefect() {
        return false;
    }

    @Override
    public boolean wasLaunched() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }
}

