/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    JPanel myPanel;
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private JRadioButton myRbListen;
    private JRadioButton myRbAttach;
    private JTextField myAddressField;
    private JTextField myHostField;
    private JTextField myPortField;
    private JPanel myShmemPanel;
    private JPanel mySocketPanel;
    private ConfigurationArgumentsHelpArea myHelpArea;
    @NonNls
    private ConfigurationArgumentsHelpArea myJDK13HelpArea;
    private String myHostName = "";
    @NonNls
    protected static final String LOCALHOST = "localhost";

    public RemoteConfigurable() {
        this.$$$setupUI$$$();
        this.myJDK13HelpArea.setLabelText(ExecutionBundle.message((String)"environment.variables.helper.use.arguments.jdk13.label", (Object[])new Object[0]));
        ButtonGroup transportGroup = new ButtonGroup();
        transportGroup.add(this.myRbSocket);
        transportGroup.add(this.myRbShmem);
        ButtonGroup connectionGroup = new ButtonGroup();
        connectionGroup.add(this.myRbListen);
        connectionGroup.add(this.myRbAttach);
        DocumentAdapter helpTextUpdater = new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myRbSocket.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source.equals(RemoteConfigurable.this.myRbSocket)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(false);
                    RemoteConfigurable.this.mySocketPanel.setVisible(true);
                } else if (source.equals(RemoteConfigurable.this.myRbShmem)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(true);
                    RemoteConfigurable.this.mySocketPanel.setVisible(false);
                }
                RemoteConfigurable.this.myPanel.repaint();
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbShmem.addActionListener(listener);
        this.myRbSocket.addActionListener(listener);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isAttach = RemoteConfigurable.this.myRbAttach.isSelected();
                if (!isAttach && RemoteConfigurable.this.myHostField.isEditable()) {
                    RemoteConfigurable.this.myHostName = RemoteConfigurable.this.myHostField.getText();
                }
                RemoteConfigurable.this.myHostField.setEditable(isAttach);
                RemoteConfigurable.this.myHostField.setEnabled(isAttach);
                RemoteConfigurable.this.myHostField.setText(isAttach ? RemoteConfigurable.this.myHostName : RemoteConfigurable.LOCALHOST);
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbAttach.addItemListener(updateListener);
        this.myRbListen.addItemListener(updateListener);
        FocusAdapter fieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.addFocusListener(fieldFocusListener);
        this.myPortField.addFocusListener(fieldFocusListener);
    }

    public void applyEditorTo(@NotNull RemoteConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/remote/RemoteConfigurable.applyEditorTo must not be null");
        }
        configuration.HOST = (this.myHostField.isEditable() ? this.myHostField.getText() : this.myHostName).trim();
        if ("".equals(configuration.HOST)) {
            configuration.HOST = null;
        }
        configuration.PORT = this.myPortField.getText().trim();
        if ("".equals(configuration.PORT)) {
            configuration.PORT = null;
        }
        configuration.SHMEM_ADDRESS = this.myAddressField.getText().trim();
        if ("".equals(configuration.SHMEM_ADDRESS)) {
            configuration.SHMEM_ADDRESS = null;
        }
        configuration.USE_SOCKET_TRANSPORT = this.myRbSocket.isSelected();
        configuration.SERVER_MODE = this.myRbListen.isSelected();
    }

    public void resetEditorFrom(RemoteConfiguration configuration) {
        if (!SystemInfo.isWindows) {
            configuration.USE_SOCKET_TRANSPORT = true;
            this.myRbShmem.setEnabled(false);
            this.myAddressField.setEditable(false);
        }
        this.myAddressField.setText(configuration.SHMEM_ADDRESS);
        this.myHostName = configuration.HOST;
        this.myHostField.setText(configuration.HOST);
        this.myPortField.setText(configuration.PORT);
        if (configuration.USE_SOCKET_TRANSPORT) {
            this.myRbSocket.doClick();
        } else {
            this.myRbShmem.doClick();
        }
        if (configuration.SERVER_MODE) {
            this.myRbListen.doClick();
        } else {
            this.myRbAttach.doClick();
        }
        this.myRbShmem.setEnabled(SystemInfo.isWindows);
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/remote/RemoteConfigurable.createEditor must not return null");
        }
        return jPanel;
    }

    public void disposeEditor() {
    }

    private void updateHelpText() {
        boolean useSockets = !this.myRbShmem.isSelected();
        RemoteConnection connection = new RemoteConnection(useSockets, this.myHostName, useSockets ? this.myPortField.getText().trim() : this.myAddressField.getText().trim(), this.myRbListen.isSelected());
        String cmdLine = connection.getLaunchCommandLine();
        this.myHelpArea.updateText(cmdLine);
        this.myJDK13HelpArea.updateText("-Xnoagent -Djava.compiler=NONE " + cmdLine);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.remote.debugging.allows.you.to.connect.idea.to.a.running.jvm.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(3, 5, 5, 5), 5, 8, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, new Dimension(-1, 170), null, new Dimension(-1, 170)));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.settings.border"), 0, 0, null, null));
        this.mySocketPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myPortField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myHostField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.host.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.port.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myShmemPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.address.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myRbSocket = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.socket.radio"));
        jPanel5.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbShmem = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.radio"));
        jPanel5.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.debugger.mode.label"));
        jPanel5.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myRbAttach = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.attach.radio"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbListen = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.listen.radio"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.transport.label"));
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHelpArea = configurationArgumentsHelpArea2 = new ConfigurationArgumentsHelpArea();
        jPanel3.add((Component)configurationArgumentsHelpArea2, new GridConstraints(1, 0, 1, 1, 8, 3, 6, 7, null, new Dimension(150, 100), null));
        this.myJDK13HelpArea = configurationArgumentsHelpArea = new ConfigurationArgumentsHelpArea();
        jPanel3.add((Component)configurationArgumentsHelpArea, new GridConstraints(2, 0, 1, 1, 8, 3, 6, 7, null, new Dimension(150, 100), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

