/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Nullable;

public class ColoredProcessHandler
extends OSProcessHandler {
    public static final char TEXT_ATTRS_PREFIX_CH = '\u001b';
    public static final String TEXT_ATTRS_PREFIX = Character.toString('\u001b') + "[";
    private Key myCurrentColor;
    @Nullable
    private final Charset myCharset;

    public static TextAttributes getByKey(TextAttributesKey key) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
    }

    public ColoredProcessHandler(Process process, String commandLine) {
        this(process, commandLine, null);
    }

    public ColoredProcessHandler(Process process, String commandLine, @Nullable Charset charset) {
        super(process, commandLine);
        this.myCharset = charset;
    }

    public Charset getCharset() {
        if (this.myCharset != null) {
            return this.myCharset;
        }
        return super.getCharset();
    }

    public final void notifyTextAvailable(String text, Key outputType) {
        int macroPos;
        if (outputType != ProcessOutputTypes.STDOUT) {
            this.textAvailable(text, outputType);
            return;
        }
        int pos = 0;
        while ((macroPos = text.indexOf(TEXT_ATTRS_PREFIX, pos)) >= 0) {
            int macroEndPos;
            if (pos != macroPos) {
                this.textAvailable(text.substring(pos, macroPos), this.getCurrentOutputAttributes());
            }
            if ((macroEndPos = text.indexOf(109, macroPos)) < 0) break;
            ColoredOutputTypeRegistry registry = ColoredOutputTypeRegistry.getInstance();
            String colorAttribute = text.substring(macroPos, macroEndPos + 1);
            this.myCurrentColor = registry.getOutputKey(colorAttribute);
            pos = macroEndPos + 1;
        }
        if (pos < text.length()) {
            this.textAvailable(text.substring(pos), this.getCurrentOutputAttributes());
        }
    }

    protected void textAvailable(String text, Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }

    private Key getCurrentOutputAttributes() {
        return this.myCurrentColor != null ? this.myCurrentColor : ProcessOutputTypes.STDOUT;
    }
}

