/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;

public final class SingleConfigurationConfigurable<Config extends RunConfiguration>
extends SettingsEditorConfigurable<RunnerAndConfigurationSettingsImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.SingleConfigurationConfigurable");
    private final PlainDocument myNameDocument = new PlainDocument();
    private ValidationResult myLastValidationResult = null;
    private boolean myValidationResultValid = false;
    private MyValidatableComponent myComponent;
    private final String myDisplayName;
    private final String myHelpTopic;
    private final Icon myIcon;
    private boolean myBrokenConfiguration;

    private SingleConfigurationConfigurable(RunnerAndConfigurationSettingsImpl settings) {
        super((SettingsEditor)new ConfigurationSettingsEditorWrapper(settings), (Object)settings);
        RunConfiguration configuration = ((RunnerAndConfigurationSettingsImpl)this.getSettings()).getConfiguration();
        this.myDisplayName = ((RunnerAndConfigurationSettingsImpl)this.getSettings()).getName();
        this.myHelpTopic = null;
        this.myIcon = configuration.getType().getIcon();
        this.myBrokenConfiguration = configuration instanceof UnknownRunConfiguration;
        this.setNameText(configuration.getName());
        this.myNameDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                SingleConfigurationConfigurable.this.setModified(true);
            }
        });
        this.getEditor().addSettingsEditorListener(new SettingsEditorListener(){

            public void stateChanged(SettingsEditor settingsEditor) {
                SingleConfigurationConfigurable.this.myValidationResultValid = false;
            }
        });
    }

    public static <Config extends RunConfiguration> SingleConfigurationConfigurable<Config> editSettings(RunnerAndConfigurationSettingsImpl settings) {
        SingleConfigurationConfigurable<Config> configurable = new SingleConfigurationConfigurable<Config>(settings);
        configurable.reset();
        return configurable;
    }

    public void apply() throws ConfigurationException {
        ((RunnerAndConfigurationSettingsImpl)this.getSettings()).setName(this.getNameText());
        super.apply();
    }

    public void reset() {
        RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)this.getSettings();
        if (configuration != null) {
            this.setNameText(configuration.getName());
        }
        super.reset();
    }

    public final JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyValidatableComponent();
            this.myComponent.myNameText.setEnabled(!this.myBrokenConfiguration);
        }
        return this.myComponent.getWholePanel();
    }

    private ValidationResult getValidationResult() {
        if (!this.myValidationResultValid) {
            this.myLastValidationResult = null;
            try {
                RunnerAndConfigurationSettingsImpl snapshot = this.getSnapshot();
                if (snapshot != null) {
                    snapshot.setName(this.getNameText());
                    snapshot.checkSettings();
                    block3: for (ProgramRunner runner : RunnerRegistry.getInstance().getRegisteredRunners()) {
                        for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                            if (!runner.canRun(executor.getId(), (RunProfile)snapshot.getConfiguration())) continue;
                            SingleConfigurationConfigurable.checkConfiguration(runner, snapshot);
                            continue block3;
                        }
                    }
                }
            }
            catch (RuntimeConfigurationException exception) {
                this.myLastValidationResult = exception != null ? new ValidationResult(exception.getLocalizedMessage(), exception.getTitle(), exception.getQuickFix()) : null;
            }
            catch (ConfigurationException e) {
                this.myLastValidationResult = new ValidationResult(e.getLocalizedMessage(), ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), null);
            }
            this.myValidationResultValid = true;
        }
        return this.myLastValidationResult;
    }

    private static void checkConfiguration(ProgramRunner runner, RunnerAndConfigurationSettings snapshot) throws RuntimeConfigurationException {
        RunnerSettings runnerSettings = snapshot.getRunnerSettings(runner);
        ConfigurationPerRunnerSettings configurationSettings = snapshot.getConfigurationSettings(runner);
        try {
            runner.checkConfiguration(runnerSettings, configurationSettings);
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
    }

    public final void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    public final String getNameText() {
        try {
            return this.myNameDocument.getText(0, this.myNameDocument.getLength());
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public final void addNameListner(DocumentListener listener) {
        this.myNameDocument.addDocumentListener(listener);
    }

    public final void setNameText(String name) {
        try {
            this.myNameDocument.replace(0, this.myNameDocument.getLength(), name, null);
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
        }
    }

    public final boolean isValid() {
        return this.getValidationResult() == null;
    }

    public final JTextField getNameTextField() {
        return this.myComponent.myNameText;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    public Config getConfiguration() {
        return (Config)((RunnerAndConfigurationSettingsImpl)this.getSettings()).getConfiguration();
    }

    public RunnerAndConfigurationSettingsImpl getSnapshot() throws ConfigurationException {
        SettingsEditor editor = this.getEditor();
        return editor == null ? null : (RunnerAndConfigurationSettingsImpl)editor.getSnapshot();
    }

    private class MyValidatableComponent {
        private JLabel myNameLabel;
        private JTextField myNameText;
        private JComponent myWholePanel;
        private JPanel myComponentPlace;
        private JPanel myOutlinePanel;
        private JLabel myWarningLabel;
        private JButton myFixButton;
        private JScrollPane myScrollPane;
        private Runnable myQuickFix = null;

        public MyValidatableComponent() {
            this.$$$setupUI$$$();
            this.myNameLabel.setLabelFor(this.myNameText);
            this.myNameText.setDocument(SingleConfigurationConfigurable.this.myNameDocument);
            SingleConfigurationConfigurable.this.getEditor().addSettingsEditorListener(new SettingsEditorListener(){

                public void stateChanged(SettingsEditor settingsEditor) {
                    MyValidatableComponent.this.updateWarning();
                }
            });
            this.myWarningLabel.setIcon(IconLoader.getIcon((String)"/runConfigurations/configurationWarning.png"));
            this.myScrollPane.setBorder(null);
            this.myComponentPlace.setLayout(new GridBagLayout());
            this.myComponentPlace.add((Component)this.getEditorComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.myComponentPlace.doLayout();
            this.myFixButton.setIcon(IconLoader.getIcon((String)"/actions/quickfixBulb.png"));
            this.updateWarning();
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValidatableComponent.this.myQuickFix == null) {
                        return;
                    }
                    MyValidatableComponent.this.myQuickFix.run();
                    SingleConfigurationConfigurable.this.myValidationResultValid = false;
                    MyValidatableComponent.this.updateWarning();
                }
            });
        }

        public final JComponent getWholePanel() {
            return this.myWholePanel;
        }

        public JComponent getEditorComponent() {
            return SingleConfigurationConfigurable.this.getEditor().getComponent();
        }

        public ValidationResult getValidationResult() {
            return SingleConfigurationConfigurable.this.getValidationResult();
        }

        private void updateWarning() {
            ValidationResult configurationException = this.getValidationResult();
            if (configurationException != null) {
                this.myOutlinePanel.setVisible(true);
                this.myWarningLabel.setVisible(true);
                this.myWarningLabel.setText(this.generateWarningLabelText(configurationException));
                Runnable quickFix = configurationException.getQuickFix();
                if (quickFix == null) {
                    this.myFixButton.setVisible(false);
                } else {
                    this.myFixButton.setVisible(true);
                    this.myQuickFix = quickFix;
                }
            } else {
                this.myOutlinePanel.setVisible(false);
                this.myWarningLabel.setVisible(false);
                this.myFixButton.setVisible(false);
            }
        }

        @NonNls
        private String generateWarningLabelText(ValidationResult configurationException) {
            return "<html><body><b>" + configurationException.getTitle() + ": </b>" + configurationException.getMessage() + "</body></html>";
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JScrollPane jScrollPane;
            JButton jButton;
            JLabel jLabel;
            JPanel jPanel2;
            JTextField jTextField;
            JLabel jLabel2;
            JPanel jPanel3 = new JPanel();
            this.myWholePanel = jPanel3;
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myNameLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("edit.run.configuration.run.configuration.name.label"));
            jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameText = jTextField = new JTextField();
            jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myOutlinePanel = jPanel2 = new JPanel();
            jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 2, 1, 3, 0, null, null, new Dimension(-1, 2)));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 2, null, null, null));
            this.myWarningLabel = jLabel = new JLabel();
            jLabel.setText("####################");
            jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
            this.myFixButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("fix.run.configuration.problem.button"));
            jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel3.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myScrollPane = jScrollPane = new JScrollPane();
            jPanel3.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
            this.myComponentPlace = jPanel = new JPanel();
            jScrollPane.setViewportView(jPanel);
            jLabel2.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

