/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerImpl
extends RunManagerEx
implements JDOMExternalizable,
ProjectComponent {
    private final Project myProject;
    private final Map<String, ConfigurationType> myTypesByName = new LinkedHashMap<String, ConfigurationType>();
    private final Map<String, RunnerAndConfigurationSettingsImpl> myConfigurations = new LinkedHashMap<String, RunnerAndConfigurationSettingsImpl>();
    private final Map<Integer, Boolean> mySharedConfigurations = new TreeMap<Integer, Boolean>();
    private final Map<RunConfiguration, Map<Key<? extends BeforeRunTask>, BeforeRunTask>> myConfigurationToBeforeTasksMap = new WeakHashMap();
    private final Map<String, RunnerAndConfigurationSettingsImpl> myTemplateConfigurationsMap = new HashMap<String, RunnerAndConfigurationSettingsImpl>();
    private RunnerAndConfigurationSettingsImpl mySelectedConfiguration = null;
    private String mySelectedConfig = null;
    @NonNls
    protected static final String CONFIGURATION = "configuration";
    private ConfigurationType[] myTypes;
    private final RunManagerConfig myConfig;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String SELECTED_ATTR = "selected";
    @NonNls
    private static final String METHOD = "method";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String VALUE = "value";
    private List<Element> myUnloadedElements = null;
    private JDOMExternalizableStringList myOrder = new JDOMExternalizableStringList();
    private final List<RunManagerListener> myListeners = ContainerUtil.createEmptyCOWList();
    private Map<Key<? extends BeforeRunTask>, BeforeRunTaskProvider> myBeforeStepsMap;
    private Map<String, Key<? extends BeforeRunTask>> myProviderKeysMap;

    public RunManagerImpl(Project project, PropertiesComponent propertiesComponent) {
        this.myConfig = new RunManagerConfig(propertiesComponent, this);
        this.myProject = project;
        this.initConfigurationTypes();
    }

    public final void initializeConfigurationTypes(@NotNull ConfigurationType[] factories) {
        if (factories == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.initializeConfigurationTypes must not be null");
        }
        Arrays.sort(factories, new Comparator<ConfigurationType>(){

            @Override
            public int compare(ConfigurationType o1, ConfigurationType o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>(Arrays.asList(factories));
        types.add((ConfigurationType)UnknownConfigurationType.INSTANCE);
        this.myTypes = types.toArray(new ConfigurationType[types.size()]);
        for (ConfigurationType type : factories) {
            this.myTypesByName.put(type.getId(), type);
        }
        UnknownConfigurationType broken = UnknownConfigurationType.INSTANCE;
        this.myTypesByName.put(broken.getId(), (ConfigurationType)broken);
    }

    private void initConfigurationTypes() {
        ConfigurationType[] configurationTypes = (ConfigurationType[])Extensions.getExtensions((ExtensionPointName)ConfigurationType.CONFIGURATION_TYPE_EP);
        this.initializeConfigurationTypes(configurationTypes);
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void projectOpened() {
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettingsImpl createConfiguration(String name, ConfigurationFactory factory) {
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = this.createConfiguration(this.doCreateConfiguration(name, factory), factory);
        if (runnerAndConfigurationSettingsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.createConfiguration must not return null");
        }
        return runnerAndConfigurationSettingsImpl;
    }

    protected RunConfiguration doCreateConfiguration(String name, ConfigurationFactory factory) {
        return factory.createConfiguration(name, this.getConfigurationTemplate(factory).getConfiguration());
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettingsImpl createConfiguration(RunConfiguration runConfiguration, ConfigurationFactory factory) {
        RunnerAndConfigurationSettingsImpl template = this.getConfigurationTemplate(factory);
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, this.getBeforeRunTasks(template.getConfiguration()));
        this.shareConfiguration(runConfiguration, this.isConfigurationShared(template));
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this, runConfiguration, false);
        settings.importRunnerAndConfigurationSettings(template);
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = settings;
        if (runnerAndConfigurationSettingsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.createConfiguration must not return null");
        }
        return runnerAndConfigurationSettingsImpl;
    }

    public void projectClosed() {
        this.myTemplateConfigurationsMap.clear();
    }

    @Override
    public RunManagerConfig getConfig() {
        return this.myConfig;
    }

    public ConfigurationType[] getConfigurationFactories() {
        return (ConfigurationType[])this.myTypes.clone();
    }

    public ConfigurationType[] getConfigurationFactories(boolean includeUnknown) {
        ConfigurationType[] configurationTypes = (ConfigurationType[])this.myTypes.clone();
        if (!includeUnknown) {
            ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>();
            for (ConfigurationType configurationType : configurationTypes) {
                if (configurationType instanceof UnknownConfigurationType) continue;
                types.add(configurationType);
            }
            return types.toArray(new ConfigurationType[types.size()]);
        }
        return configurationTypes;
    }

    public RunConfiguration[] getConfigurations(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.getConfigurations must not be null");
        }
        ArrayList<RunConfiguration> array = new ArrayList<RunConfiguration>();
        for (RunnerAndConfigurationSettingsImpl myConfiguration : this.getSortedConfigurations()) {
            RunConfiguration configuration = myConfiguration.getConfiguration();
            ConfigurationType configurationType = configuration.getType();
            if (!type.getId().equals(configurationType.getId())) continue;
            array.add(configuration);
        }
        return array.toArray(new RunConfiguration[array.size()]);
    }

    public RunConfiguration[] getAllConfigurations() {
        RunConfiguration[] result = new RunConfiguration[this.myConfigurations.size()];
        int i = 0;
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.getSortedConfigurations()) {
            result[i] = runnerAndConfigurationSettings.getConfiguration();
            ++i;
        }
        return result;
    }

    @Nullable
    public RunnerAndConfigurationSettingsImpl getSettings(RunConfiguration configuration) {
        for (RunnerAndConfigurationSettingsImpl settings : this.getSortedConfigurations()) {
            if (settings.getConfiguration() != configuration) continue;
            return settings;
        }
        return null;
    }

    @Override
    public RunnerAndConfigurationSettingsImpl[] getConfigurationSettings(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.getConfigurationSettings must not be null");
        }
        LinkedHashSet<RunnerAndConfigurationSettingsImpl> array = new LinkedHashSet<RunnerAndConfigurationSettingsImpl>();
        for (RunnerAndConfigurationSettingsImpl configuration : this.getSortedConfigurations()) {
            ConfigurationType configurationType = configuration.getType();
            if (configurationType == null || !type.getId().equals(configurationType.getId())) continue;
            array.add(configuration);
        }
        return array.toArray(new RunnerAndConfigurationSettingsImpl[array.size()]);
    }

    public RunnerAndConfigurationSettingsImpl getConfigurationTemplate(ConfigurationFactory factory) {
        RunnerAndConfigurationSettingsImpl template = this.myTemplateConfigurationsMap.get(factory.getType().getId() + "." + factory.getName());
        if (template == null) {
            template = new RunnerAndConfigurationSettingsImpl(this, factory.createTemplateConfiguration(this.myProject, (RunManager)this), true);
            if (template.getConfiguration() instanceof UnknownRunConfiguration) {
                ((UnknownRunConfiguration)template.getConfiguration()).setDoNotStore(true);
            }
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), template);
        }
        return template;
    }

    @Override
    public void addConfiguration(RunnerAndConfigurationSettingsImpl settings, boolean shared, Map<Key<? extends BeforeRunTask>, BeforeRunTask> tasks) {
        RunConfiguration configuration = settings.getConfiguration();
        String configName = RunManagerImpl.getUniqueName(configuration);
        this.myConfigurations.put(configName, settings);
        this.checkRecentsLimit();
        this.mySharedConfigurations.put(configuration.getUniqueID(), shared);
        this.setBeforeRunTasks(configuration, tasks);
    }

    void checkRecentsLimit() {
        block0: while (this.getTempConfigurations().length > this.getConfig().getRecentsLimit()) {
            Iterator<Map.Entry<String, RunnerAndConfigurationSettingsImpl>> it = this.myConfigurations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RunnerAndConfigurationSettingsImpl> entry = it.next();
                if (!entry.getValue().isTemporary()) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public static String getUniqueName(RunConfiguration settings) {
        return settings.getType().getDisplayName() + "." + settings.getName();
    }

    public RunConfiguration getConfigurationByUniqueID(int id) {
        for (RunConfiguration each : this.getAllConfigurations()) {
            if (each.getUniqueID() != id) continue;
            return each;
        }
        return null;
    }

    public RunConfiguration getConfigurationByUniqueName(String name) {
        for (RunConfiguration each : this.getAllConfigurations()) {
            if (!RunManagerImpl.getUniqueName(each).equals(name)) continue;
            return each;
        }
        return null;
    }

    public void removeConfigurations(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.removeConfigurations must not be null");
        }
        Iterator<RunnerAndConfigurationSettingsImpl> it = this.getSortedConfigurations().iterator();
        while (it.hasNext()) {
            RunnerAndConfigurationSettings configuration = it.next();
            ConfigurationType configurationType = configuration.getType();
            if (configurationType == null || !type.getId().equals(configurationType.getId())) continue;
            it.remove();
        }
    }

    @Override
    public Collection<RunnerAndConfigurationSettingsImpl> getSortedConfigurations() {
        if (this.myOrder != null && !this.myOrder.isEmpty()) {
            HashMap<String, RunnerAndConfigurationSettingsImpl> settings = new HashMap<String, RunnerAndConfigurationSettingsImpl>(this.myConfigurations);
            this.myConfigurations.clear();
            ArrayList<String> order = new ArrayList<String>(settings.keySet());
            Collections.sort(order, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return RunManagerImpl.this.myOrder.indexOf((Object)o1) - RunManagerImpl.this.myOrder.indexOf((Object)o2);
                }
            });
            for (String configName : order) {
                this.myConfigurations.put(configName, settings.get(configName));
            }
            this.myOrder = null;
        }
        return this.myConfigurations.values();
    }

    @Override
    public void removeConfiguration(RunnerAndConfigurationSettingsImpl settings) {
        Iterator<RunnerAndConfigurationSettingsImpl> it = this.getSortedConfigurations().iterator();
        while (it.hasNext()) {
            RunnerAndConfigurationSettings configuration = it.next();
            if (!configuration.equals(settings)) continue;
            if (this.mySelectedConfiguration != null && settings.equals(this.mySelectedConfiguration)) {
                this.setSelectedConfiguration(null);
            }
            it.remove();
            break;
        }
    }

    @Override
    public RunnerAndConfigurationSettingsImpl getSelectedConfiguration() {
        if (this.mySelectedConfiguration == null && this.mySelectedConfig != null) {
            this.mySelectedConfiguration = this.myConfigurations.get(this.mySelectedConfig);
            this.mySelectedConfig = null;
        }
        return this.mySelectedConfiguration;
    }

    @Override
    public void setSelectedConfiguration(RunnerAndConfigurationSettingsImpl configuration) {
        this.mySelectedConfiguration = configuration;
    }

    public static boolean canRunConfiguration(@NotNull RunnerAndConfigurationSettingsImpl configuration, @NotNull Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.canRunConfiguration must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.canRunConfiguration must not be null");
        }
        try {
            configuration.checkSettings(executor);
        }
        catch (RuntimeConfigurationError er) {
            return false;
        }
        catch (RuntimeConfigurationException e) {
            return true;
        }
        return true;
    }

    public void writeExternal(@NotNull Element parentNode) throws WriteExternalException {
        if (parentNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.writeExternal must not be null");
        }
        this.writeContext(parentNode);
        for (RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettings : this.myTemplateConfigurationsMap.values()) {
            if (runnerAndConfigurationSettings.getConfiguration() instanceof UnknownRunConfiguration && ((UnknownRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).isDoNotStore()) continue;
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        Collection<RunnerAndConfigurationSettingsImpl> configurations = this.getStableConfigurations().values();
        for (RunnerAndConfigurationSettingsImpl configuration : configurations) {
            if (this.isConfigurationShared(configuration)) continue;
            this.addConfigurationElement(parentNode, configuration);
        }
        JDOMExternalizableStringList order = new JDOMExternalizableStringList();
        order.addAll((Collection)ContainerUtil.findAll(this.myConfigurations.keySet(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return !s.startsWith("Unknown");
            }
        }));
        order.writeExternal(parentNode);
        if (this.myUnloadedElements != null) {
            for (Element unloadedElement : this.myUnloadedElements) {
                parentNode.addContent((Element)unloadedElement.clone());
            }
        }
    }

    public void writeContext(Element parentNode) throws WriteExternalException {
        for (RunnerAndConfigurationSettingsImpl configurationSettings : this.myConfigurations.values()) {
            if (!configurationSettings.isTemporary()) continue;
            this.addConfigurationElement(parentNode, configurationSettings, CONFIGURATION);
        }
        if (this.mySelectedConfiguration != null) {
            parentNode.setAttribute(SELECTED_ATTR, RunManagerImpl.getUniqueName(this.mySelectedConfiguration.getConfiguration()));
        }
    }

    public void addConfigurationElement(Element parentNode, RunnerAndConfigurationSettingsImpl template) throws WriteExternalException {
        this.addConfigurationElement(parentNode, template, CONFIGURATION);
    }

    private void addConfigurationElement(Element parentNode, RunnerAndConfigurationSettingsImpl settings, String elementType) throws WriteExternalException {
        Element configurationElement = new Element(elementType);
        parentNode.addContent(configurationElement);
        settings.writeExternal(configurationElement);
        if (!(settings.getConfiguration() instanceof UnknownRunConfiguration)) {
            Map<Key<? extends BeforeRunTask>, BeforeRunTask> templateTasks;
            Map<Key<? extends BeforeRunTask>, BeforeRunTask> tasks = this.getBeforeRunTasks(settings.getConfiguration());
            if (!settings.isTemplate()) {
                RunnerAndConfigurationSettingsImpl templateSettings = this.getConfigurationTemplate(settings.getFactory());
                templateTasks = this.getBeforeRunTasks(templateSettings.getConfiguration());
            } else {
                templateTasks = null;
            }
            ArrayList<Key<? extends BeforeRunTask>> order = new ArrayList<Key<? extends BeforeRunTask>>(tasks.keySet());
            Collections.sort(order, new Comparator<Key<? extends BeforeRunTask>>(){

                @Override
                public int compare(Key<? extends BeforeRunTask> o1, Key<? extends BeforeRunTask> o2) {
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            Element methodsElement = new Element(METHOD);
            for (Key key : order) {
                BeforeRunTask templateTask;
                BeforeRunTask beforeRunTask = tasks.get(key);
                if (templateTasks != null && beforeRunTask.equals((Object)(templateTask = templateTasks.get(key)))) continue;
                Element child = new Element(OPTION);
                child.setAttribute(NAME_ATTR, key.toString());
                beforeRunTask.writeExternal(child);
                methodsElement.addContent(child);
            }
            configurationElement.addContent(methodsElement);
        }
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.clear();
        Comparator<Element> comparator = new Comparator<Element>(){

            @Override
            public int compare(Element a, Element b) {
                boolean bDefault;
                boolean aDefault = Boolean.valueOf(a.getAttributeValue("default", "false"));
                return aDefault == (bDefault = Boolean.valueOf(b.getAttributeValue("default", "false")).booleanValue()) ? 0 : (aDefault ? -1 : 1);
            }
        };
        List children = parentNode.getChildren();
        ArrayList<Element> sortedElements = new ArrayList<Element>();
        for (Object aChildren : children) {
            Element element = (Element)aChildren;
            if (!Comparing.strEqual((String)element.getName(), (String)CONFIGURATION)) continue;
            sortedElements.add(element);
        }
        Collections.sort(sortedElements, comparator);
        for (Element element : sortedElements) {
            if (this.loadConfiguration(element, false) != null) continue;
            if (this.myUnloadedElements == null) {
                this.myUnloadedElements = new ArrayList<Element>(2);
            }
            this.myUnloadedElements.add(element);
        }
        this.myOrder.readExternal(parentNode);
        this.mySelectedConfig = parentNode.getAttributeValue(SELECTED_ATTR);
        this.fireBeforeRunTasksUpdated();
    }

    public void readContext(Element parentNode) throws InvalidDataException {
        RunnerAndConfigurationSettingsImpl configurationSettings;
        List children = parentNode.getChildren();
        this.mySelectedConfig = parentNode.getAttributeValue(SELECTED_ATTR);
        for (Object aChildren : children) {
            Element element = (Element)aChildren;
            if (this.mySelectedConfig == null && Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) {
                this.mySelectedConfig = element.getAttributeValue(NAME_ATTR);
            }
            this.loadConfiguration(element, false);
        }
        if (this.mySelectedConfig != null && (configurationSettings = this.myConfigurations.get(this.mySelectedConfig)) != null) {
            this.mySelectedConfiguration = null;
        }
    }

    private void clear() {
        this.myConfigurations.clear();
        this.myUnloadedElements = null;
        this.myConfigurationToBeforeTasksMap.clear();
        this.mySharedConfigurations.clear();
    }

    @Nullable
    public RunnerAndConfigurationSettingsImpl loadConfiguration(Element element, boolean isShared) throws InvalidDataException {
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this);
        settings.readExternal(element);
        ConfigurationFactory factory = settings.getFactory();
        if (factory == null) {
            return null;
        }
        Element methodsElement = element.getChild(METHOD);
        Map<Key<? extends BeforeRunTask>, BeforeRunTask> map = this.readStepsBeforeRun(methodsElement, settings);
        if (settings.isTemplate()) {
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), settings);
            this.setBeforeRunTasks(settings.getConfiguration(), map);
        } else {
            if (Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) {
                this.mySelectedConfiguration = settings;
            }
            this.addConfiguration(settings, isShared, map);
        }
        return settings;
    }

    @NotNull
    private Map<Key<? extends BeforeRunTask>, BeforeRunTask> readStepsBeforeRun(Element child, RunnerAndConfigurationSettingsImpl settings) {
        HashMap<Key<? extends BeforeRunTask>, BeforeRunTask> map = new HashMap<Key<? extends BeforeRunTask>, BeforeRunTask>();
        if (child != null) {
            for (Object o : child.getChildren(OPTION)) {
                Element methodElement = (Element)o;
                String providerName = methodElement.getAttributeValue(NAME_ATTR);
                Key<? extends BeforeRunTask> id = this.getProviderKey(providerName);
                BeforeRunTaskProvider provider = this.getProvider(id);
                BeforeRunTask beforeRunTask = provider.createTask(settings.getConfiguration());
                if (beforeRunTask == null) continue;
                beforeRunTask.readExternal(methodElement);
                map.put(id, beforeRunTask);
            }
        }
        HashMap<Key<? extends BeforeRunTask>, BeforeRunTask> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.readStepsBeforeRun must not return null");
        }
        return hashMap;
    }

    @Nullable
    public ConfigurationType getConfigurationType(String typeName) {
        return this.myTypesByName.get(typeName);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (factoryName == null) {
            factoryName = type != null ? type.getConfigurationFactories()[0].getName() : null;
        }
        return this.findFactoryOfTypeNameByName(typeName, factoryName);
    }

    @Nullable
    private ConfigurationFactory findFactoryOfTypeNameByName(String typeName, String factoryName) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (type == null) {
            type = this.myTypesByName.get("Unknown");
        }
        return RunManagerImpl.findFactoryOfTypeByName(type, factoryName);
    }

    @Nullable
    private static ConfigurationFactory findFactoryOfTypeByName(ConfigurationType type, String factoryName) {
        ConfigurationFactory[] factories;
        if (factoryName == null) {
            return null;
        }
        if (type instanceof UnknownConfigurationType) {
            return type.getConfigurationFactories()[0];
        }
        for (ConfigurationFactory factory : factories = type.getConfigurationFactories()) {
            if (!factoryName.equals(factory.getName())) continue;
            return factory;
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("RunManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.getComponentName must not return null");
        }
        return "RunManager";
    }

    @Override
    public void setTemporaryConfiguration(@NotNull RunnerAndConfigurationSettingsImpl tempConfiguration) {
        if (tempConfiguration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.setTemporaryConfiguration must not be null");
        }
        tempConfiguration.setTemporary(true);
        this.addConfiguration(tempConfiguration, this.isConfigurationShared(tempConfiguration), this.getBeforeRunTasks(tempConfiguration.getConfiguration()));
        this.setActiveConfiguration(tempConfiguration);
    }

    @Override
    public void setActiveConfiguration(RunnerAndConfigurationSettingsImpl configuration) {
        this.setSelectedConfiguration(configuration);
    }

    public Map<String, RunnerAndConfigurationSettingsImpl> getStableConfigurations() {
        LinkedHashMap<String, RunnerAndConfigurationSettingsImpl> result = new LinkedHashMap<String, RunnerAndConfigurationSettingsImpl>(this.myConfigurations);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((RunnerAndConfigurationSettingsImpl)entry.getValue()).isTemporary()) continue;
            it.remove();
        }
        return result;
    }

    public boolean isTemporary(RunConfiguration configuration) {
        return Arrays.asList(this.getTempConfigurations()).contains(configuration);
    }

    @Override
    public boolean isTemporary(RunnerAndConfigurationSettingsImpl settings) {
        return settings.isTemporary();
    }

    public RunConfiguration[] getTempConfigurations() {
        List configurations = ContainerUtil.mapNotNull(this.myConfigurations.values(), (Function)new NullableFunction<RunnerAndConfigurationSettingsImpl, RunConfiguration>(){

            public RunConfiguration fun(RunnerAndConfigurationSettingsImpl settings) {
                return settings.isTemporary() ? settings.getConfiguration() : null;
            }
        });
        return configurations.toArray(new RunConfiguration[configurations.size()]);
    }

    public void makeStable(RunConfiguration configuration) {
        RunnerAndConfigurationSettingsImpl settings = this.getSettings(configuration);
        if (settings != null) {
            settings.setTemporary(false);
        }
    }

    public RunnerAndConfigurationSettings createRunConfiguration(String name, ConfigurationFactory type) {
        return this.createConfiguration(name, type);
    }

    @Override
    public boolean isConfigurationShared(RunnerAndConfigurationSettingsImpl settings) {
        Boolean shared = this.mySharedConfigurations.get(settings.getConfiguration().getUniqueID());
        if (shared == null) {
            RunnerAndConfigurationSettingsImpl template = this.getConfigurationTemplate(settings.getFactory());
            shared = this.mySharedConfigurations.get(template.getConfiguration().getUniqueID());
        }
        return shared != null && shared != false;
    }

    @Override
    public <T extends BeforeRunTask> Collection<T> getBeforeRunTasks(Key<T> taskProviderID, boolean includeOnlyActiveTasks) {
        ArrayList<T> tasks = new ArrayList<T>();
        if (includeOnlyActiveTasks) {
            HashSet<RunnerAndConfigurationSettingsImpl> checkedTemplates = new HashSet<RunnerAndConfigurationSettingsImpl>();
            for (RunnerAndConfigurationSettingsImpl settings : this.myConfigurations.values()) {
                T runTask = this.getBeforeRunTask(settings.getConfiguration(), taskProviderID);
                if (runTask != null && runTask.isEnabled()) {
                    tasks.add(runTask);
                    continue;
                }
                RunnerAndConfigurationSettingsImpl template = this.getConfigurationTemplate(settings.getFactory());
                if (checkedTemplates.contains(template)) continue;
                checkedTemplates.add(template);
                T templateTask = this.getBeforeRunTask(template.getConfiguration(), taskProviderID);
                if (templateTask == null || !templateTask.isEnabled()) continue;
                tasks.add(templateTask);
            }
        } else {
            T task;
            for (RunnerAndConfigurationSettingsImpl settings : this.myTemplateConfigurationsMap.values()) {
                task = this.getBeforeRunTask(settings.getConfiguration(), taskProviderID);
                if (task == null) continue;
                tasks.add(task);
            }
            for (RunnerAndConfigurationSettingsImpl settings : this.myConfigurations.values()) {
                task = this.getBeforeRunTask(settings.getConfiguration(), taskProviderID);
                if (task == null) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettingsImpl findConfigurationByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunManagerImpl.findConfigurationByName must not be null");
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends BeforeRunTask> T getBeforeRunTask(RunConfiguration settings, Key<T> taskProviderID) {
        Map<Key<? extends BeforeRunTask>, BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks == null) {
            tasks = this.getBeforeRunTasks(settings);
            this.myConfigurationToBeforeTasksMap.put(settings, tasks);
        }
        return (T)tasks.get(taskProviderID);
    }

    public Map<Key<? extends BeforeRunTask>, BeforeRunTask> getBeforeRunTasks(RunConfiguration settings) {
        Map<Key<? extends BeforeRunTask>, BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks != null) {
            HashMap<Key<? extends BeforeRunTask>, BeforeRunTask> _tasks = new HashMap<Key<? extends BeforeRunTask>, BeforeRunTask>();
            for (Map.Entry<Key<? extends BeforeRunTask>, BeforeRunTask> entry : tasks.entrySet()) {
                _tasks.put(entry.getKey(), entry.getValue().clone());
            }
            return _tasks;
        }
        RunnerAndConfigurationSettingsImpl template = this.getConfigurationTemplate(settings.getFactory());
        Map<Key<? extends BeforeRunTask>, BeforeRunTask> templateTasks = this.myConfigurationToBeforeTasksMap.get(template.getConfiguration());
        if (templateTasks != null) {
            HashMap<Key<? extends BeforeRunTask>, BeforeRunTask> _tasks = new HashMap<Key<? extends BeforeRunTask>, BeforeRunTask>();
            for (Map.Entry<Key<? extends BeforeRunTask>, BeforeRunTask> entry : templateTasks.entrySet()) {
                _tasks.put(entry.getKey(), entry.getValue().clone());
            }
            return _tasks;
        }
        HashMap<Key<? extends BeforeRunTask>, BeforeRunTask> _tasks = new HashMap<Key<? extends BeforeRunTask>, BeforeRunTask>();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            BeforeRunTask task = provider.createTask(settings);
            if (task == null) continue;
            Key providerID = provider.getId();
            _tasks.put((Key<? extends BeforeRunTask>)providerID, task);
            settings.getFactory().configureBeforeRunTaskDefaults(providerID, task);
        }
        return _tasks;
    }

    public void shareConfiguration(RunConfiguration runConfiguration, boolean shareConfiguration) {
        this.mySharedConfigurations.put(runConfiguration.getUniqueID(), shareConfiguration);
    }

    public final void setBeforeRunTasks(RunConfiguration runConfiguration, Map<Key<? extends BeforeRunTask>, BeforeRunTask> tasks) {
        Map<Key<? extends BeforeRunTask>, BeforeRunTask> taskMap = this.getBeforeRunTasks(runConfiguration);
        for (Map.Entry<Key<? extends BeforeRunTask>, BeforeRunTask> entry : tasks.entrySet()) {
            taskMap.put(entry.getKey(), entry.getValue());
        }
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, taskMap);
        this.fireBeforeRunTasksUpdated();
    }

    public final void resetBeforeRunTasks(RunConfiguration runConfiguration) {
        this.myConfigurationToBeforeTasksMap.remove(runConfiguration);
        this.fireBeforeRunTasksUpdated();
    }

    @Override
    public void addConfiguration(RunnerAndConfigurationSettingsImpl settings, boolean isShared) {
        this.addConfiguration(settings, isShared, Collections.<Key<BeforeRunTask>, BeforeRunTask>emptyMap());
    }

    public static RunManagerImpl getInstanceImpl(Project project) {
        return (RunManagerImpl)RunManager.getInstance((Project)project);
    }

    public void removeNotExistingSharedConfigurations(Set<String> existing) {
        Iterator<Map.Entry<String, RunnerAndConfigurationSettingsImpl>> it = this.myConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RunnerAndConfigurationSettingsImpl> c = it.next();
            RunnerAndConfigurationSettingsImpl o = c.getValue();
            if (o.isTemplate() || !this.isConfigurationShared(o) || existing.contains(RunManagerImpl.getUniqueName(o.getConfiguration()))) continue;
            it.remove();
        }
    }

    @Override
    public void addRunManagerListener(RunManagerListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeRunManagerListener(RunManagerListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireBeforeRunTasksUpdated() {
        for (RunManagerListener each : this.myListeners) {
            each.beforeRunTasksChanged();
        }
    }

    @NotNull
    private synchronized BeforeRunTaskProvider getProvider(Key<? extends BeforeRunTask> providerId) {
        if (this.myBeforeStepsMap == null) {
            this.initProviderMaps();
        }
        BeforeRunTaskProvider beforeRunTaskProvider = this.myBeforeStepsMap.get(providerId);
        if (beforeRunTaskProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.getProvider must not return null");
        }
        return beforeRunTaskProvider;
    }

    @NotNull
    private synchronized Key<? extends BeforeRunTask> getProviderKey(String keyString) {
        Key<? extends BeforeRunTask> id;
        if (this.myProviderKeysMap == null) {
            this.initProviderMaps();
        }
        if ((id = this.myProviderKeysMap.get(keyString)) == null) {
            UnknownBeforeRunTaskProvider provider = new UnknownBeforeRunTaskProvider(keyString);
            id = provider.getId();
            this.myProviderKeysMap.put(keyString, id);
            this.myBeforeStepsMap.put(id, provider);
        }
        Key<? extends BeforeRunTask> key = id;
        if (key == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunManagerImpl.getProviderKey must not return null");
        }
        return key;
    }

    private void initProviderMaps() {
        this.myBeforeStepsMap = new HashMap<Key<? extends BeforeRunTask>, BeforeRunTaskProvider>();
        this.myProviderKeysMap = new HashMap<String, Key<? extends BeforeRunTask>>();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            Key id = provider.getId();
            this.myBeforeStepsMap.put((Key<? extends BeforeRunTask>)id, provider);
            this.myProviderKeysMap.put(id.toString(), (Key<? extends BeforeRunTask>)id);
        }
    }
}

