/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class ExecutionManagerImpl
extends ExecutionManager
implements ProjectComponent {
    private final Project myProject;
    private RunContentManagerImpl myContentManager;

    ExecutionManagerImpl(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        ((RunContentManagerImpl)this.getContentManager()).init();
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public RunContentManager getContentManager() {
        if (this.myContentManager == null) {
            this.myContentManager = new RunContentManagerImpl(this.myProject);
            Disposer.register((Disposable)this.myProject, (Disposable)this.myContentManager);
        }
        return this.myContentManager;
    }

    public ProcessHandler[] getRunningProcesses() {
        RunContentDescriptor[] descriptors;
        ArrayList<ProcessHandler> handlers = new ArrayList<ProcessHandler>();
        for (RunContentDescriptor descriptor : descriptors = ((RunContentManagerImpl)this.getContentManager()).getAllDescriptors()) {
            ProcessHandler processHandler;
            if (descriptor == null || (processHandler = descriptor.getProcessHandler()) == null) continue;
            handlers.add(processHandler);
        }
        return handlers.toArray(new ProcessHandler[handlers.size()]);
    }

    public void compileAndRun(final Runnable startRunnable, final RunProfile configuration, final RunProfileState state) {
        Runnable antAwareRunnable = new Runnable(){

            @Override
            public void run() {
                if (configuration instanceof RunConfiguration) {
                    final RunConfiguration runConfiguration = (RunConfiguration)configuration;
                    RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(ExecutionManagerImpl.this.myProject);
                    final LinkedHashMap activeProviders = new LinkedHashMap();
                    for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)ExecutionManagerImpl.this.myProject)) {
                        Object task = runManager.getBeforeRunTask(runConfiguration, provider.getId());
                        if (task == null || !task.isEnabled()) continue;
                        activeProviders.put(provider, task);
                    }
                    if (!activeProviders.isEmpty()) {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                ConfigurationPerRunnerSettings configurationSettings = state.getConfigurationSettings();
                                DataContext projectContext = SimpleDataContext.getProjectContext(ExecutionManagerImpl.this.myProject);
                                DataContext dataContext = configurationSettings != null ? SimpleDataContext.getSimpleContext("RunnerId", configurationSettings.getRunnerId(), projectContext) : projectContext;
                                for (BeforeRunTaskProvider provider : activeProviders.keySet()) {
                                    if (provider.executeTask(dataContext, runConfiguration, (BeforeRunTask)activeProviders.get(provider))) continue;
                                    return;
                                }
                                DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).smartInvokeLater(startRunnable);
                            }
                        });
                    } else {
                        startRunnable.run();
                    }
                } else {
                    startRunnable.run();
                }
            }
        };
        antAwareRunnable.run();
    }

    @NotNull
    public String getComponentName() {
        if ("ExecutionManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/ExecutionManagerImpl.getComponentName must not return null");
        }
        return "ExecutionManager";
    }
}

