/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationAction
extends ComboBoxAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.RunConfigurationAction");
    private static final Key<ComboBoxAction.ComboBoxButton> BUTTON_KEY = Key.create((String)"COMBOBOX_BUTTON");

    public void actionPerformed(AnActionEvent e) {
        IdeFrameImpl ideFrame = RunConfigurationAction.findFrame((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
        ComboBoxAction.ComboBoxButton button = (ComboBoxAction.ComboBoxButton)ideFrame.getRootPane().getClientProperty(BUTTON_KEY);
        if (button == null || !button.isShowing()) {
            return;
        }
        button.showPopup();
    }

    private static IdeFrameImpl findFrame(Component component) {
        return IJSwingUtilities.findParentOfType(component, IdeFrameImpl.class);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if ("MainMenu".equals(e.getPlace())) {
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
            presentation.setEnabled(RunConfigurationAction.findFrame((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) != null);
            return;
        }
        try {
            if (project == null || project.isDisposed() || !project.isInitialized()) {
                RunConfigurationAction.updateButton(null, null, presentation);
                presentation.setEnabled(false);
            } else if (DumbService.getInstance((Project)project).isDumb()) {
                presentation.setEnabled(false);
            } else {
                RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
                RunnerAndConfigurationSettingsImpl selected = runManager.getSelectedConfiguration();
                RunConfigurationAction.updateButton(selected, project, presentation);
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updateButton(@Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/RunConfigurationAction.updateButton must not be null");
        }
        if (project != null && settings != null) {
            presentation.setText(settings.getName(), false);
            RunConfigurationAction.setConfigurationIcon(presentation, settings, project);
        } else {
            presentation.setText("");
            presentation.setIcon(null);
        }
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project) {
        try {
            presentation.setIcon(ExecutionUtil.getConfigurationIcon(project, settings));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return new ComboBoxAction.ComboBoxButton(presentation){

            protected void updateButtonSize() {
                super.updateButtonSize();
                Dimension preferredSize = this.getPreferredSize();
                int width = preferredSize.width;
                int height = preferredSize.height;
                if (width > height * 15) {
                    this.setPreferredSize(new Dimension(height * 15, height));
                }
            }

            public void addNotify() {
                super.addNotify();
                IdeFrameImpl frame = RunConfigurationAction.findFrame((Component)((Object)this));
                LOG.assertTrue(frame != null);
                frame.getRootPane().putClientProperty(BUTTON_KEY, (Object)this);
            }
        };
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        if (project != null) {
            ConfigurationType[] types;
            RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
            allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
            allActionsGroup.add((AnAction)new SaveTemporaryAction());
            allActionsGroup.addSeparator();
            for (ConfigurationType type : types = runManager.getConfigurationFactories()) {
                RunnerAndConfigurationSettingsImpl[] configurations;
                DefaultActionGroup actionGroup = new DefaultActionGroup();
                for (RunnerAndConfigurationSettingsImpl configuration : configurations = runManager.getConfigurationSettings(type)) {
                    MenuAction action = new MenuAction(configuration, project);
                    actionGroup.add((AnAction)action);
                }
                allActionsGroup.add((AnAction)actionGroup);
                allActionsGroup.addSeparator();
            }
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/actions/RunConfigurationAction.createPopupActionGroup must not return null");
        }
        return defaultActionGroup;
    }

    private static class MenuAction
    extends AnAction {
        private final RunnerAndConfigurationSettingsImpl myConfiguration;
        private final Project myProject;

        public MenuAction(RunnerAndConfigurationSettingsImpl configuration, Project project) {
            this.myConfiguration = configuration;
            this.myProject = project;
            String name = configuration.getName();
            if (name == null || name.length() == 0) {
                name = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription("Start " + configuration.getType().getConfigurationTypeDescription() + " '" + name + "'");
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(AnActionEvent e) {
            RunManagerEx.getInstanceEx(this.myProject).setActiveConfiguration(this.myConfiguration);
            RunConfigurationAction.updateButton(this.myConfiguration, this.myProject, e.getPresentation());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            this.updateIcon(e.getPresentation());
        }
    }

    private static class SaveTemporaryAction
    extends AnAction {
        private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/saveTempConfig.png");

        public SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
            if (project != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(SaveTemporaryAction.chooseTempConfiguration(project));
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunConfiguration configuration = SaveTemporaryAction.chooseTempConfiguration(project);
            if (configuration == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.message((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{configuration.getName()}));
                presentation.setDescription(presentation.getText());
                presentation.setVisible(true);
                presentation.setEnabled(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }

        @Nullable
        private static RunConfiguration chooseTempConfiguration(Project project) {
            RunConfiguration[] tempConfigurations = RunManager.getInstance((Project)project).getTempConfigurations();
            if (tempConfigurations.length > 0) {
                RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                if (selectedConfiguration == null || !selectedConfiguration.isTemporary()) {
                    return tempConfigurations[0];
                }
                return selectedConfiguration.getConfiguration();
            }
            return null;
        }
    }
}

