/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.ide.util.PropertiesComponent;
import org.jetbrains.annotations.NonNls;

public class RunManagerConfig {
    public static final String MAKE = ExecutionBundle.message((String)"before.run.property.make", (Object[])new Object[0]);
    private final StoringPropertyContainer myProperties;
    private final PropertiesComponent myPropertiesComponent;
    @NonNls
    private static final String RECENTS_LIMIT = "recentsLimit";

    public RunManagerConfig(PropertiesComponent propertiesComponent, RunManagerImpl manager) {
        this.myPropertiesComponent = propertiesComponent;
        this.myProperties = new StoringPropertyContainer("RunManagerConfig.", propertiesComponent);
    }

    public int getRecentsLimit() {
        try {
            return Integer.valueOf(this.myPropertiesComponent.getOrInit(RECENTS_LIMIT, "5"));
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public void setRecentsLimit(int recentsLimit) {
        this.myPropertiesComponent.setValue(RECENTS_LIMIT, Integer.toString(recentsLimit));
    }
}

