/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class MessagePool {
    private static final int MAX_POOL_SIZE_FOR_FATALS = 100;
    private final List<AbstractMessage> myIdeFatals = new ArrayList<AbstractMessage>();
    private final Set<MessagePoolListener> myListeners = new HashSet<MessagePoolListener>();
    private final MessageGrouper myFatalsGrouper;
    private boolean ourJvmIsShuttingDown = false;

    MessagePool(int maxGroupSize, int timeout) {
        this.myFatalsGrouper = new MessageGrouper(timeout, maxGroupSize);
        JobScheduler.getScheduler().scheduleAtFixedRate(this.myFatalsGrouper, 300L, 300L, TimeUnit.MILLISECONDS);
    }

    public static MessagePool getInstance() {
        return MessagePoolHolder.ourInstance;
    }

    public void addIdeFatalMessage(LoggingEvent aEvent) {
        this.addIdeFatalMessage(new LogMessage(aEvent));
    }

    public void addIdeFatalMessage(IdeaLoggingEvent aEvent) {
        this.addIdeFatalMessage(new LogMessage(aEvent));
    }

    private void addIdeFatalMessage(LogMessage message) {
        if (this.myIdeFatals.size() < 100) {
            this.myFatalsGrouper.add(message);
        } else if (this.myIdeFatals.size() == 100) {
            this.myFatalsGrouper.add(new LogMessage(new LoggingEvent(DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]), Category.getRoot(), Priority.ERROR, null, (Throwable)new TooManyErrorsException())));
        }
    }

    public boolean isFatalErrorsPoolEmpty() {
        return this.myIdeFatals.isEmpty();
    }

    public boolean hasUnreadMessages() {
        for (int i = 0; i < this.myIdeFatals.size(); ++i) {
            AbstractMessage message = this.myIdeFatals.get(i);
            if (message.isRead()) continue;
            return true;
        }
        return false;
    }

    public List<AbstractMessage> getFatalErrors(boolean aIncludeReadMessages, boolean aIncludeSubmittedMessages) {
        ArrayList<AbstractMessage> result = new ArrayList<AbstractMessage>();
        for (int i = 0; i < this.myIdeFatals.size(); ++i) {
            AbstractMessage each = this.myIdeFatals.get(i);
            if (!each.isRead() && !each.isSubmitted()) {
                result.add(each);
                continue;
            }
            if ((!each.isRead() || !aIncludeReadMessages) && (!each.isSubmitted() || !aIncludeSubmittedMessages)) continue;
            result.add(each);
        }
        return result;
    }

    public void clearFatals() {
        this.myIdeFatals.clear();
        this.notifyListenersClear();
    }

    public void addListener(MessagePoolListener aListener) {
        this.myListeners.add(aListener);
    }

    public void removeListener(MessagePoolListener aListener) {
        this.myListeners.remove(aListener);
    }

    private void notifyListenersAdd() {
        if (this.ourJvmIsShuttingDown) {
            return;
        }
        MessagePoolListener[] messagePoolListeners = this.myListeners.toArray(new MessagePoolListener[this.myListeners.size()]);
        for (int i = 0; i < messagePoolListeners.length; ++i) {
            messagePoolListeners[i].newEntryAdded();
        }
    }

    private void notifyListenersClear() {
        MessagePoolListener[] messagePoolListeners = this.myListeners.toArray(new MessagePoolListener[this.myListeners.size()]);
        for (int i = 0; i < messagePoolListeners.length; ++i) {
            messagePoolListeners[i].poolCleared();
        }
    }

    public void setJvmIsShuttingDown() {
        this.ourJvmIsShuttingDown = true;
    }

    static class TooManyErrorsException
    extends Exception {
        TooManyErrorsException() {
            super(DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]));
        }
    }

    private class MessageGrouper
    implements Runnable {
        private final int myTimeOut;
        private final int myMaxGroupSize;
        private final List<AbstractMessage> myMessages = new ArrayList<AbstractMessage>();
        private int myAccumulatedTime;

        public MessageGrouper(int timeout, int maxGroupSize) {
            this.myTimeOut = timeout;
            this.myMaxGroupSize = maxGroupSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myAccumulatedTime += 300;
            if (this.myAccumulatedTime > this.myTimeOut) {
                List<AbstractMessage> list = this.myMessages;
                synchronized (list) {
                    if (this.myMessages.size() > 0) {
                        this.post();
                    }
                }
            }
        }

        private void post() {
            AbstractMessage message = this.myMessages.size() == 1 ? this.myMessages.get(0) : new GroupedLogMessage(new ArrayList<AbstractMessage>(this.myMessages));
            this.myMessages.clear();
            MessagePool.this.myIdeFatals.add(message);
            MessagePool.this.notifyListenersAdd();
            this.myAccumulatedTime = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(AbstractMessage message) {
            this.myAccumulatedTime = 0;
            List<AbstractMessage> list = this.myMessages;
            synchronized (list) {
                this.myMessages.add(message);
                if (this.myMessages.size() >= this.myMaxGroupSize) {
                    this.post();
                }
            }
        }
    }

    private static class MessagePoolHolder {
        private static final MessagePool ourInstance = new MessagePool(20, 1000);

        private MessagePoolHolder() {
        }
    }
}

