/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.ExtensionPoints;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IdeErrorsDialog
extends DialogWrapper
implements MessagePoolListener,
TypeSafeDataProvider {
    public static DataKey<String> CURRENT_TRACE_KEY = DataKey.create((String)"current_stack_trace_key");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.IdeErrorsDialog");
    private JTextPane myDetailsPane;
    private List<AbstractMessage> myFatalErrors;
    private final List<ArrayList<AbstractMessage>> myModel = new ArrayList<ArrayList<AbstractMessage>>();
    private final MessagePool myMessagePool;
    private JLabel myCountLabel;
    private JLabel myBlameLabel;
    private JLabel myInfoLabel;
    private JCheckBox myImmediatePopupCheckbox;
    private int myIndex = 0;
    @NonNls
    public static final String IMMEDIATE_POPUP_OPTION = "IMMEDIATE_FATAL_ERROR_POPUP";

    public IdeErrorsDialog(MessagePool messagePool) {
        super((Component)JOptionPane.getRootFrame(), false);
        this.myMessagePool = messagePool;
        this.init();
    }

    @Override
    public void newEntryAdded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeErrorsDialog.this.rebuildHeaders();
            }
        });
    }

    @Override
    public void poolCleared() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeErrorsDialog.this.doOKAction();
            }
        });
    }

    protected Action[] createActions() {
        return new Action[]{new ShutdownAction(), new ClearFatalsAction(), new CloseAction()};
    }

    protected Action[] createLeftSideActions() {
        AnAction analyze;
        if (((ApplicationEx)ApplicationManager.getApplication()).isInternal() && (analyze = ActionManager.getInstance().getAction("AnalyzeStacktraceOnError")) != null) {
            return new Action[]{new AbstractAction(analyze.getTemplatePresentation().getText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataContext dataContext = ((DataManagerImpl)DataManager.getInstance()).getDataContextTest((Component)e.getSource());
                    AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", analyze.getTemplatePresentation(), ActionManager.getInstance(), e.getModifiers());
                    Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
                    this.setEnabled(project != null);
                    if (project != null) {
                        analyze.actionPerformed(event);
                        IdeErrorsDialog.this.doOKAction();
                    }
                }
            }};
        }
        return new Action[0];
    }

    public void calcData(DataKey key, DataSink sink) {
        AbstractMessage msg;
        if (CURRENT_TRACE_KEY == key && (msg = this.getMessageAt(this.myIndex)) != null) {
            sink.put(CURRENT_TRACE_KEY, (Object)(msg.getMessage() + msg.getThrowableText()));
        }
    }

    private ActionToolbar createNavigationToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        BackAction back = new BackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), this.getRootPane());
        group.add((AnAction)back);
        ForwardAction forward = new ForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), this.getRootPane());
        group.add((AnAction)forward);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    private void updateControls() {
        this.updateCountLabel();
        this.updateBlameLabel();
        this.updateInfoLabel();
        this.updateDetailsPane();
    }

    private void updateInfoLabel() {
        AbstractMessage message = this.getMessageAt(this.myIndex);
        if (message != null) {
            StringBuffer txt = new StringBuffer();
            txt.append(DiagnosticBundle.message("error.list.message.info", DateFormatUtil.formatDate((Date)new Date(), (Date)message.getDate()), this.myModel.get(this.myIndex).size()));
            if (message.isSubmitted()) {
                SubmittedReportInfo info = message.getSubmissionInfo();
                if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.FAILED) {
                    txt.append(DiagnosticBundle.message("error.list.message.submission.failed", new Object[0]));
                } else if (info.getLinkText() != null) {
                    txt.append(DiagnosticBundle.message("error.list.message.submitted.as.link", info.getLinkText()));
                    if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE) {
                        txt.append(DiagnosticBundle.message("error.list.message.duplicate", new Object[0]));
                    }
                } else {
                    txt.append(DiagnosticBundle.message("error.list.message.submitted", new Object[0]));
                }
                txt.append(". ");
            } else if (!message.isRead()) {
                txt.append(DiagnosticBundle.message("error.list.message.unread", new Object[0]));
            }
            this.myInfoLabel.setText(txt.toString());
        } else {
            this.myInfoLabel.setText("");
        }
    }

    private void updateBlameLabel() {
        AbstractMessage message = this.getMessageAt(this.myIndex);
        if (message != null && !(message.getThrowable() instanceof MessagePool.TooManyErrorsException)) {
            PluginId pluginId = IdeErrorsDialog.findPluginId(message.getThrowable());
            if (pluginId == null) {
                if (message.getThrowable() instanceof AbstractMethodError) {
                    this.myBlameLabel.setText(DiagnosticBundle.message("error.list.message.blame.unknown.plugin", new Object[0]));
                } else {
                    this.myBlameLabel.setText(DiagnosticBundle.message("error.list.message.blame.core", ApplicationNamesInfo.getInstance().getProductName()));
                }
            } else {
                Application app = ApplicationManager.getApplication();
                this.myBlameLabel.setText(DiagnosticBundle.message("error.list.message.blame.plugin", app.getPlugin(pluginId).getName()));
            }
        } else {
            this.myBlameLabel.setText("");
        }
    }

    private void updateDetailsPane() {
        AbstractMessage message = this.getMessageAt(this.myIndex);
        if (message != null) {
            this.showMessageDetails(message);
        } else {
            this.hideMessageDetails();
        }
    }

    private void updateCountLabel() {
        this.myCountLabel.setText(DiagnosticBundle.message("error.list.message.index.count", Integer.toString(this.myIndex + 1), this.myModel.size()));
    }

    protected JComponent createCenterPanel() {
        this.setTitle(DiagnosticBundle.message("error.list.title", new Object[0]));
        JPanel root = new JPanel(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(new FlowLayout());
        this.myImmediatePopupCheckbox = new JCheckBox(DiagnosticBundle.message("error.list.popup.immediately.checkbox", new Object[0]));
        this.myImmediatePopupCheckbox.setSelected(PropertiesComponent.getInstance().isTrueValue(IMMEDIATE_POPUP_OPTION));
        this.myCountLabel = new JLabel();
        this.myBlameLabel = new JLabel();
        this.myInfoLabel = new JLabel();
        ActionToolbar navToolbar = this.createNavigationToolbar();
        toolbar.add(navToolbar.getComponent());
        toolbar.add(this.myCountLabel);
        top.add((Component)toolbar, "West");
        JPanel blamePanel = new JPanel(new FlowLayout());
        blamePanel.add(this.myBlameLabel);
        ActionToolbar blameToolbar = this.createBlameToolbar();
        blamePanel.add(blameToolbar.getComponent());
        top.add((Component)blamePanel, "East");
        root.add((Component)top, "North");
        this.myDetailsPane = new JTextPane();
        this.myDetailsPane.setEditable(false);
        JPanel infoPanel = new JPanel(new BorderLayout());
        JPanel gapPanel = new JPanel(new FlowLayout(0, 7, 0));
        gapPanel.add(this.myInfoLabel);
        infoPanel.add((Component)gapPanel, "North");
        infoPanel.add((Component)new JScrollPane(this.myDetailsPane), "Center");
        root.add((Component)infoPanel, "Center");
        root.add((Component)this.myImmediatePopupCheckbox, "South");
        root.setPreferredSize(new Dimension(600, 550));
        this.rebuildHeaders();
        this.moveSelectionToEarliestMessage();
        this.updateControls();
        return root;
    }

    private ActionToolbar createBlameToolbar() {
        DefaultActionGroup blameGroup = new DefaultActionGroup();
        BlameAction blameAction = new BlameAction();
        blameGroup.add((AnAction)blameAction);
        blameAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)), this.getRootPane());
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)blameGroup, true);
    }

    private AbstractMessage getMessageAt(int idx) {
        if (idx < 0 || idx >= this.myModel.size()) {
            return null;
        }
        return this.myModel.get(idx).get(0);
    }

    private void moveSelectionToEarliestMessage() {
        this.myIndex = 0;
        for (int i = 0; i < this.myModel.size(); ++i) {
            AbstractMessage each = this.getMessageAt(i);
            if (each.isRead()) continue;
            this.myIndex = i;
            break;
        }
        this.updateControls();
    }

    private void rebuildHeaders() {
        this.myModel.clear();
        this.myFatalErrors = this.myMessagePool.getFatalErrors(true, true);
        Map<String, ArrayList<AbstractMessage>> hash2Messages = IdeErrorsDialog.buildHashcode2MessageListMap(this.myFatalErrors);
        for (ArrayList<AbstractMessage> abstractMessages : hash2Messages.values()) {
            this.myModel.add(abstractMessages);
        }
        this.updateControls();
    }

    private static Map<String, ArrayList<AbstractMessage>> buildHashcode2MessageListMap(List<AbstractMessage> aErrors) {
        LinkedHashMap<String, ArrayList<AbstractMessage>> hash2Messages = new LinkedHashMap<String, ArrayList<AbstractMessage>>();
        for (AbstractMessage each : aErrors) {
            ArrayList list;
            String hashcode = IdeErrorsDialog.getThrowableHashCode(each.getThrowable());
            if (hash2Messages.containsKey(hashcode)) {
                list = (ArrayList)hash2Messages.get(hashcode);
            } else {
                list = new ArrayList();
                hash2Messages.put(hashcode, list);
            }
            list.add(0, each);
        }
        return hash2Messages;
    }

    private void showMessageDetails(AbstractMessage aMessage) {
        if (aMessage.getThrowable() instanceof MessagePool.TooManyErrorsException) {
            this.myDetailsPane.setText(aMessage.getThrowable().getMessage());
        } else {
            this.myDetailsPane.setText(new StringBuffer().append(aMessage.getMessage()).append("\n").append(aMessage.getThrowableText()).toString());
        }
        if (this.myDetailsPane.getCaret() != null) {
            this.myDetailsPane.setCaretPosition(0);
        }
    }

    private void hideMessageDetails() {
        this.myDetailsPane.setText("");
    }

    @Nullable
    public static PluginId findPluginId(Throwable t) {
        String className;
        StackTraceElement[] elements;
        if (t instanceof PluginException) {
            return ((PluginException)t).getPluginId();
        }
        for (StackTraceElement element : elements = t.getStackTrace()) {
            String className2 = element.getClassName();
            if (!PluginManager.isPluginClass((String)className2)) continue;
            return PluginManager.getPluginByClassName((String)className2);
        }
        if (t instanceof NoSuchMethodException) {
            if (t.getMessage() != null) {
                className = "";
                StringTokenizer tok = new StringTokenizer(t.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.length() <= 0 || !Character.isJavaIdentifierStart(token.charAt(0))) continue;
                    className = className + token;
                }
                if (PluginManager.isPluginClass((String)className)) {
                    return PluginManager.getPluginByClassName((String)className);
                }
            }
        } else if (t instanceof ClassNotFoundException) {
            if (t.getMessage() != null && PluginManager.isPluginClass((String)(className = t.getMessage()))) {
                return PluginManager.getPluginByClassName((String)className);
            }
        } else if (t instanceof AbstractMethodError && t.getMessage() != null) {
            String s = t.getMessage();
            int pos = s.indexOf(40);
            if (pos >= 0 && (pos = (s = s.substring(0, pos)).lastIndexOf(46)) >= 0 && PluginManager.isPluginClass((String)(s = s.substring(0, pos)))) {
                return PluginManager.getPluginByClassName((String)s);
            }
        } else if (t instanceof ExtensionException && PluginManager.isPluginClass((String)(className = ((ExtensionException)t).getExtensionClass().getName()))) {
            return PluginManager.getPluginByClassName((String)className);
        }
        return null;
    }

    @Nullable
    public static ErrorReportSubmitter getSubmitter(Throwable throwable) {
        ErrorReportSubmitter[] reporters;
        if (throwable instanceof MessagePool.TooManyErrorsException || throwable instanceof AbstractMethodError) {
            return null;
        }
        PluginId pluginId = IdeErrorsDialog.findPluginId(throwable);
        try {
            reporters = (ErrorReportSubmitter[])Extensions.getExtensions((ExtensionPointName)ExtensionPoints.ERROR_HANDLER_EP);
        }
        catch (Throwable t) {
            return null;
        }
        ErrorReportSubmitter submitter = null;
        for (ErrorReportSubmitter reporter : reporters) {
            PluginDescriptor descriptor = reporter.getPluginDescriptor();
            if ((pluginId != null || descriptor != null && PluginId.getId((String)"com.intellij") != descriptor.getPluginId()) && (descriptor == null || !Comparing.equal((Object)pluginId, (Object)descriptor.getPluginId()))) continue;
            submitter = reporter;
        }
        return submitter;
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue(IMMEDIATE_POPUP_OPTION, String.valueOf(this.myImmediatePopupCheckbox.isSelected()));
        this.markAllAsRead();
        super.doOKAction();
    }

    private void markAllAsRead() {
        for (AbstractMessage each : this.myFatalErrors) {
            each.setRead(true);
        }
    }

    public void doCancelAction() {
        PropertiesComponent.getInstance().setValue(IMMEDIATE_POPUP_OPTION, String.valueOf(this.myImmediatePopupCheckbox.isSelected()));
        this.markAllAsRead();
        super.doCancelAction();
    }

    protected String getDimensionServiceKey() {
        return "IdeErrosDialog";
    }

    private static String getThrowableHashCode(Throwable exception) {
        try {
            return IdeErrorsDialog.md5(StringUtil.getThrowableText((Throwable)exception), "stack-trace");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    private static String md5(String buffer, @NonNls String key) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buffer.getBytes());
        byte[] code = md5.digest(key.getBytes());
        BigInteger bi = new BigInteger(code).abs();
        return bi.abs().toString(16);
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", DiagnosticBundle.message("error.list.close.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.doOKAction();
        }
    }

    private class BlameAction
    extends AnAction
    implements DumbAware {
        public BlameAction() {
            super(DiagnosticBundle.message("error.list.submit.action", new Object[0]), DiagnosticBundle.message("error.list.submit.action.description", new Object[0]), IconLoader.getIcon((String)"/actions/startDebugger.png"));
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            AbstractMessage logMessage = IdeErrorsDialog.this.getMessageAt(IdeErrorsDialog.this.myIndex);
            if (logMessage == null) {
                presentation.setEnabled(false);
                return;
            }
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(logMessage.getThrowable());
            if (logMessage.isSubmitted() || submitter == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
            presentation.setDescription(submitter.getReportActionText());
        }

        public void actionPerformed(AnActionEvent e) {
            AbstractMessage logMessage = IdeErrorsDialog.this.getMessageAt(IdeErrorsDialog.this.myIndex);
            this.reportMessage(logMessage);
            IdeErrorsDialog.this.rebuildHeaders();
            IdeErrorsDialog.this.updateControls();
        }

        private void reportMessage(AbstractMessage logMessage) {
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(logMessage.getThrowable());
            if (submitter != null) {
                logMessage.setSubmitted(submitter.submit(this.getEvents(logMessage), (Component)IdeErrorsDialog.this.getContentPane()));
            }
        }

        private IdeaLoggingEvent[] getEvents(AbstractMessage logMessage) {
            if (logMessage instanceof GroupedLogMessage) {
                List<AbstractMessage> messages = ((GroupedLogMessage)logMessage).getMessages();
                IdeaLoggingEvent[] res = new IdeaLoggingEvent[messages.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = this.getEvent(messages.get(i));
                }
                return res;
            }
            return new IdeaLoggingEvent[]{this.getEvent(logMessage)};
        }

        private IdeaLoggingEvent getEvent(AbstractMessage logMessage) {
            return new IdeaLoggingEvent(logMessage.getMessage(), logMessage.getThrowable());
        }
    }

    private class ClearFatalsAction
    extends AbstractAction {
        public ClearFatalsAction() {
            super(DiagnosticBundle.message("error.list.clear.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.myMessagePool.clearFatals();
            IdeErrorsDialog.this.doOKAction();
        }
    }

    private class ShutdownAction
    extends AbstractAction {
        public ShutdownAction() {
            super(DiagnosticBundle.message("error.list.shutdown.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.myMessagePool.setJvmIsShuttingDown();
            LaterInvocator.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().exit();
                }
            }, ModalityState.NON_MODAL);
            IdeErrorsDialog.this.doOKAction();
        }
    }

    private class ForwardAction
    extends AnAction
    implements DumbAware {
        public ForwardAction() {
            super(DiagnosticBundle.message("error.list.forward.action", new Object[0]), null, IconLoader.getIcon((String)"/actions/forward.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(IdeErrorsDialog.this.myIndex < IdeErrorsDialog.this.myModel.size() - 1);
        }
    }

    private class BackAction
    extends AnAction
    implements DumbAware {
        public BackAction() {
            super(DiagnosticBundle.message("error.list.back.action", new Object[0]), null, IconLoader.getIcon((String)"/actions/back.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(IdeErrorsDialog.this.myIndex > 0);
        }
    }
}

