/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ExpressionChildrenRenderer
extends ReferenceRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ExpressionChildrenRenderer";
    private static final Key<Value> EXPRESSION_VALUE = new Key("EXPRESSION_VALUE");
    private final CachedEvaluator myChildrenExpandable = new CachedEvaluator(){

        @Override
        protected String getClassName() {
            return ExpressionChildrenRenderer.this.getClassName();
        }
    };
    private final CachedEvaluator myChildrenExpression = new CachedEvaluator(){

        @Override
        protected String getClassName() {
            return ExpressionChildrenRenderer.this.getClassName();
        }
    };

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ExpressionChildrenRenderer clone() {
        return (ExpressionChildrenRenderer)super.clone();
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        try {
            Value childrenValue = this.evaluateChildren(evaluationContext.createEvaluationContext(value), builder.getParentDescriptor());
            NodeRenderer defaultRenderer = ((DebugProcessImpl)evaluationContext.getDebugProcess()).getDefaultRenderer(childrenValue != null ? childrenValue.type() : null);
            defaultRenderer.buildChildren(childrenValue, builder, evaluationContext);
        }
        catch (EvaluateException e) {
            ArrayList<DebuggerTreeNode> errorChildren = new ArrayList<DebuggerTreeNode>();
            errorChildren.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + e.getMessage()));
            builder.setChildren(errorChildren);
        }
    }

    private Value evaluateChildren(EvaluationContext context, NodeDescriptor descriptor) throws EvaluateException {
        ExpressionEvaluator evaluator = this.myChildrenExpression.getEvaluator(context.getProject());
        Value value = evaluator.evaluate(context);
        descriptor.putUserData(EXPRESSION_VALUE, value);
        return value;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        TextWithImports childrenExpandable;
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports childrenExpression = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPRESSION");
        if (childrenExpression != null) {
            this.setChildrenExpression(childrenExpression);
        }
        if ((childrenExpandable = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPANDABLE")) != null) {
            this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPANDABLE", this.getChildrenExpandable());
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPRESSION", this.getChildrenExpression());
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        ValueDescriptor descriptor = (ValueDescriptor)node.getParent().getDescriptor();
        Value expressionValue = descriptor.getUserData(EXPRESSION_VALUE);
        if (expressionValue == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
        }
        NodeRenderer defaultChildrenRenderer = ((DebugProcessImpl)context.getDebugProcess()).getDefaultRenderer(expressionValue.type());
        return DebuggerUtils.getInstance().substituteThis(defaultChildrenRenderer.getChildValueExpression(node, context), (PsiExpression)this.myChildrenExpression.getPsiExpression(node.getProject()).copy(), expressionValue, (StackFrameContext)context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext context, NodeDescriptor parentDescriptor) {
        EvaluationContext evaluationContext = context.createEvaluationContext(value);
        if (!"".equals(this.myChildrenExpandable.getReferenceExpression().getText())) {
            try {
                Value expanded = this.myChildrenExpandable.getEvaluator(evaluationContext.getProject()).evaluate(evaluationContext);
                if (expanded instanceof BooleanValue) {
                    return ((BooleanValue)expanded).booleanValue();
                }
            }
            catch (EvaluateException e) {
                // empty catch block
            }
        }
        try {
            Value children = this.evaluateChildren(evaluationContext, parentDescriptor);
            NodeRenderer defaultChildrenRenderer = ((DebugProcessImpl)evaluationContext.getDebugProcess()).getDefaultRenderer(value.type());
            return defaultChildrenRenderer.isExpandable(children, evaluationContext, parentDescriptor);
        }
        catch (EvaluateException e) {
            return true;
        }
    }

    public TextWithImports getChildrenExpression() {
        return this.myChildrenExpression.getReferenceExpression();
    }

    public void setChildrenExpression(TextWithImports expression) {
        this.myChildrenExpression.setReferenceExpression(expression);
    }

    public TextWithImports getChildrenExpandable() {
        return this.myChildrenExpandable.getReferenceExpression();
    }

    public void setChildrenExpandable(TextWithImports childrenExpandable) {
        this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
    }

    @Override
    public void setClassName(String name) {
        super.setClassName(name);
        this.myChildrenExpression.clear();
        this.myChildrenExpandable.clear();
    }
}

