/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.ui.DebuggerIcons;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl myFrame;
    private String myName = null;
    private Location myLocation;
    private MethodsTracker.MethodOccurrence myMethodOccurrence;
    private boolean myIsSynthetic;
    private boolean myIsInLibraryContent;
    private Long myObjectId;
    private static final Icon myObsoleteFrameIcon = IconLoader.getIcon((String)"/debugger/db_obsolete.png");
    private Icon myIcon = DebuggerIcons.STACK_FRAME_ICON;

    public StackFrameDescriptorImpl(StackFrameProxyImpl frame, MethodsTracker tracker) {
        this.myFrame = frame;
        try {
            this.myLocation = frame.location();
            ObjectReference thisObject = frame.thisObject();
            this.myObjectId = thisObject != null ? Long.valueOf(thisObject.uniqueID()) : null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(this.myLocation.method());
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)this.myMethodOccurrence.getMethod());
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile file;
                    SourcePosition position = ContextUtil.getSourcePosition(StackFrameDescriptorImpl.this);
                    PsiFile psiFile = file = position != null ? position.getFile() : null;
                    if (file == null) {
                        StackFrameDescriptorImpl.this.myIsInLibraryContent = true;
                    } else {
                        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)StackFrameDescriptorImpl.this.getDebugProcess().getProject()).getFileIndex();
                        VirtualFile vFile = file.getVirtualFile();
                        StackFrameDescriptorImpl.this.myIsInLibraryContent = vFile != null && (projectFileIndex.isInLibraryClasses(vFile) || projectFileIndex.isInLibrarySource(vFile));
                    }
                }
            });
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
            this.myLocation = null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(null);
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
        }
        catch (EvaluateException e) {
            this.myLocation = null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(null);
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
        }
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrame;
    }

    public DebugProcess getDebugProcess() {
        return this.myFrame.getVirtualMachine().getDebugProcess();
    }

    @Nullable
    public Method getMethod() {
        return this.myMethodOccurrence.getMethod();
    }

    public int getOccurrenceIndex() {
        return this.myMethodOccurrence.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.myMethodOccurrence.isRecursive();
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        Map<Long, ValueMarkup> markupMap;
        if (this.myObjectId != null && (markupMap = StackFrameDescriptorImpl.getMarkupMap(this.myFrame.getVirtualMachine().getDebugProcess())) != null) {
            return markupMap.get(this.myObjectId);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myLocation == null) {
            return "";
        }
        ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
        StringBuilder label = StringBuilderSpinAllocator.alloc();
        try {
            Method method = this.myMethodOccurrence.getMethod();
            if (method != null) {
                this.myName = method.name();
                label.append(this.myName);
                label.append("()");
            }
            if (settings.SHOW_LINE_NUMBER) {
                String lineNumber = null;
                try {
                    lineNumber = Integer.toString(this.myLocation.lineNumber());
                }
                catch (InternalError e) {
                    lineNumber = e.toString();
                }
                if (lineNumber != null) {
                    label.append(':');
                    label.append(lineNumber);
                }
            }
            if (settings.SHOW_CLASS_NAME) {
                String name = null;
                try {
                    ReferenceType refType = this.myLocation.declaringType();
                    name = refType != null ? refType.name() : null;
                }
                catch (InternalError e) {
                    name = e.toString();
                }
                if (name != null) {
                    label.append(", ");
                    int dotIndex = name.lastIndexOf(46);
                    if (dotIndex < 0) {
                        label.append(name);
                    } else {
                        label.append(name.substring(dotIndex + 1));
                        label.append(" {");
                        label.append(name.substring(0, dotIndex));
                        label.append("}");
                    }
                }
            }
            if (settings.SHOW_SOURCE_NAME) {
                try {
                    String sourceName;
                    try {
                        sourceName = this.myLocation.sourceName();
                    }
                    catch (InternalError e) {
                        sourceName = e.toString();
                    }
                    label.append(", ");
                    label.append(sourceName);
                }
                catch (AbsentInformationException exception) {
                    // empty catch block
                }
            }
            String string = label.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)label);
        }
    }

    public final boolean stackFramesEqual(StackFrameDescriptorImpl d) {
        return this.getFrameProxy().equals(d.getFrameProxy());
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl context) {
        this.myIcon = this.calcIcon();
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isInLibraryContent() {
        return this.myIsInLibraryContent;
    }

    public Location getLocation() {
        return this.myLocation;
    }

    private Icon calcIcon() {
        try {
            if (this.myFrame.isObsolete()) {
                return myObsoleteFrameIcon;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return DebuggerIcons.STACK_FRAME_ICON;
    }

    public Icon getIcon() {
        return this.myIcon;
    }
}

