/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.LineBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.debugger.ui.breakpoints.actions.GotoSourceAction;
import com.intellij.debugger.ui.breakpoints.actions.RemoveAction;
import com.intellij.debugger.ui.breakpoints.actions.SwitchViewAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleFlattenPackagesAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleGroupByClassesAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleGroupByMethodsAction;
import com.intellij.debugger.ui.breakpoints.actions.ViewSourceAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.jdom.Element;

public class LineBreakpointFactory
extends BreakpointFactory {
    @Override
    public Breakpoint createBreakpoint(Project project, Element element) {
        return new LineBreakpoint(project);
    }

    @Override
    public Icon getIcon() {
        return LineBreakpoint.ICON;
    }

    @Override
    public Icon getDisabledIcon() {
        return LineBreakpoint.DISABLED_ICON;
    }

    @Override
    public BreakpointPanel createBreakpointPanel(Project project, final DialogWrapper parentDialog) {
        BreakpointPanel panel = new BreakpointPanel(project, new LineBreakpointPropertiesPanel(project), new BreakpointPanelAction[]{new SwitchViewAction(), new GotoSourceAction(project){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                parentDialog.close(0);
            }
        }, new ViewSourceAction(project), new RemoveAction(project), new ToggleGroupByMethodsAction(), new ToggleGroupByClassesAction(), new ToggleFlattenPackagesAction()}, this.getBreakpointCategory(), DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]), "debugging.lineBreakpoint");
        return panel;
    }

    public Key<LineBreakpoint> getBreakpointCategory() {
        return LineBreakpoint.CATEGORY;
    }
}

