/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DebuggerRecents {
    private final Map<Object, LinkedList<TextWithImports>> myRecentExpressions = new HashMap();

    public static DebuggerRecents getInstance(Project project) {
        return (DebuggerRecents)ServiceManager.getService((Project)project, DebuggerRecents.class);
    }

    public LinkedList<TextWithImports> getRecents(Object id) {
        LinkedList<Object> result = this.myRecentExpressions.get(id);
        if (result == null) {
            result = new LinkedList();
            this.myRecentExpressions.put(id, result);
        }
        return result;
    }

    public void addRecent(Object id, TextWithImports recent) {
        LinkedList<TextWithImports> recents = this.getRecents(id);
        if (recents.size() >= 20) {
            recents.removeLast();
        }
        recents.remove(recent);
        recents.addFirst(recent);
    }
}

