/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final int myFrameFromBottomIndex;
    private int myFrameIndex;
    private StackFrame myStackFrame;
    private ObjectReference myThisReference;
    private ClassLoaderReference myClassLoader;
    private Boolean myIsObsolete;
    private Map<LocalVariable, Value> myAllValues;

    public StackFrameProxyImpl(ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/jdi/StackFrameProxyImpl.<init> must not be null");
        }
        super(threadProxy.getVirtualMachine());
        this.myFrameIndex = -1;
        this.myIsObsolete = null;
        this.myThreadProxy = threadProxy;
        this.myFrameFromBottomIndex = fromBottomIndex;
        this.myStackFrame = frame;
    }

    public boolean isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myIsObsolete == null) {
            try {
                boolean isObsolete = this.getVirtualMachine().canRedefineClasses() && this.location().method().isObsolete();
                this.myIsObsolete = isObsolete ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (InvalidStackFrameException e) {
                this.clearCaches();
                return this.isObsolete();
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) {
                    this.myIsObsolete = Boolean.TRUE;
                }
                throw e;
            }
        }
        return this.myIsObsolete;
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("caches cleared " + super.toString());
        }
        this.myFrameIndex = -1;
        this.myStackFrame = null;
        this.myIsObsolete = null;
        this.myThisReference = null;
        this.myClassLoader = null;
        this.myAllValues = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myStackFrame == null) {
            try {
                ThreadReference threadRef = this.myThreadProxy.getThreadReference();
                this.myStackFrame = threadRef.frame(this.getFrameIndex());
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myStackFrame;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameIndex == -1) {
            int count = this.myThreadProxy.frameCount();
            if (this.myFrameFromBottomIndex > count) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.myFrameIndex = count - this.myFrameFromBottomIndex;
        }
        return this.myFrameIndex;
    }

    public VirtualMachineProxyImpl getVirtualMachine() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public Location location() throws EvaluateException {
        try {
            return this.getStackFrame().location();
        }
        catch (InvalidStackFrameException e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.resumed", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public ThreadReferenceProxyImpl threadProxy() {
        return this.myThreadProxy;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException e) {
            return "StackFrameProxyImpl: " + e.getMessage() + "; frameFromBottom = " + this.myFrameFromBottomIndex + " threadName = " + this.threadProxy().name();
        }
    }

    public ObjectReference thisObject() throws EvaluateException {
        block4: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.checkValid();
            try {
                if (this.myThisReference == null) {
                    this.myThisReference = this.getStackFrame().thisObject();
                }
            }
            catch (InvalidStackFrameException e) {
                this.clearCaches();
                return this.thisObject();
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) break block4;
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myThisReference;
    }

    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            List<LocalVariable> list = this.getStackFrame().visibleVariables();
            ArrayList<LocalVariableProxyImpl> locals = new ArrayList<LocalVariableProxyImpl>();
            for (LocalVariable localVariable : list) {
                LOG.assertTrue(localVariable != null);
                locals.add(new LocalVariableProxyImpl(this, localVariable));
            }
            return locals;
        }
        catch (InvalidStackFrameException e) {
            this.clearCaches();
            return this.visibleVariables();
        }
        catch (AbsentInformationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public LocalVariableProxyImpl visibleVariableByName(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? new LocalVariableProxyImpl(this, variable) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            try {
                return this.getStackFrame().visibleVariableByName(name);
            }
            catch (InvalidStackFrameException e) {
                try {
                    this.clearCaches();
                    return this.getStackFrame().visibleVariableByName(name);
                }
                catch (InvalidStackFrameException e2) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e2);
                }
            }
        }
        catch (AbsentInformationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            Map<LocalVariable, Value> allValues = this.getAllValues();
            return allValues.get(localVariable.getVariable());
        }
        catch (InvalidStackFrameException e) {
            this.clearCaches();
            return this.getValue(localVariable);
        }
    }

    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrame stackFrame = this.getStackFrame();
            if (stackFrame != null) {
                try {
                    Method method = StackFrame.class.getMethod("getArgumentValues", new Class[0]);
                    return (List)method.invoke((Object)stackFrame, ArrayUtil.EMPTY_OBJECT_ARRAY);
                }
                catch (NoSuchMethodException ignored) {
                }
                catch (InvocationTargetException e) {
                    throw new EvaluateException("", e.getCause());
                }
                catch (IllegalAccessException e) {
                    LOG.error((Throwable)e);
                }
            }
            return Collections.emptyList();
        }
        catch (InvalidStackFrameException e) {
            this.clearCaches();
            return this.getArgumentValues();
        }
    }

    private Map<LocalVariable, Value> getAllValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myAllValues == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                Map<LocalVariable, Value> values = stackFrame.getValues(stackFrame.visibleVariables());
                this.myAllValues = new HashMap<LocalVariable, Value>(values.size());
                for (LocalVariable variable : values.keySet()) {
                    Value value = values.get(variable);
                    this.myAllValues.put(variable, value);
                }
            }
            catch (InconsistentDebugInfoException e) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myAllValues;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            LocalVariable variable = localVariable.getVariable();
            StackFrame stackFrame = this.getStackFrame();
            stackFrame.setValue(variable, value instanceof ObjectReference ? (ObjectReference)value : value);
            if (this.myAllValues != null) {
                this.myAllValues.put(variable, stackFrame.getValue(variable));
            }
        }
        catch (InvalidStackFrameException e) {
            this.clearCaches();
            this.setValue(localVariable, value);
        }
    }

    public int hashCode() {
        return 31 * this.myThreadProxy.hashCode() + this.myFrameFromBottomIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)obj;
        if (frameProxy == this) {
            return true;
        }
        return this.myFrameFromBottomIndex == frameProxy.myFrameFromBottomIndex && this.myThreadProxy.equals(frameProxy.myThreadProxy);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws EvaluateException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.location().declaringType().classLoader();
        }
        return this.myClassLoader;
    }

    public boolean isBottom() {
        return this.myFrameFromBottomIndex == 1;
    }

    public int getIndexFromBottom() {
        return this.myFrameFromBottomIndex;
    }
}

