/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.MethodExitRequest;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnValueWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.requests.MethodReturnValueWatcher");
    @Nullable
    private Method myLastExecutedMethod;
    @Nullable
    private Value myLastMethodReturnValue;
    @NotNull
    private final MethodExitRequest myWatchMethodReturnValueRequest;
    private java.lang.reflect.Method myReturnValueMethod;
    private volatile boolean myIsTrackingEnabled;
    private boolean myFeatureEnabled;

    public MethodReturnValueWatcher(MethodExitRequest request) {
        this.myWatchMethodReturnValueRequest = request;
        this.myIsTrackingEnabled = request.isEnabled();
        this.myFeatureEnabled = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
    }

    public boolean processMethodExitEvent(MethodExitEvent event) {
        if (event.request() != this.myWatchMethodReturnValueRequest) {
            return false;
        }
        try {
            this.myLastExecutedMethod = event.method();
            try {
                if (this.myReturnValueMethod == null) {
                    this.myReturnValueMethod = MethodExitEvent.class.getDeclaredMethod("returnValue", ArrayUtil.EMPTY_CLASS_ARRAY);
                }
                this.myLastMethodReturnValue = (Value)this.myReturnValueMethod.invoke((Object)event, new Object[0]);
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InvocationTargetException ignored) {}
        }
        catch (UnsupportedOperationException ex) {
            LOG.error((Throwable)ex);
        }
        return true;
    }

    @Nullable
    public Method getLastExecutedMethod() {
        return this.myLastExecutedMethod;
    }

    @Nullable
    public Value getLastMethodReturnValue() {
        return this.myLastMethodReturnValue;
    }

    public boolean isFeatureEnabled() {
        return this.myFeatureEnabled;
    }

    public boolean isTrackingEnabled() {
        return this.myIsTrackingEnabled;
    }

    public void setFeatureEnabled(boolean featureEnabled) {
        this.myFeatureEnabled = featureEnabled;
        this.updateRequestState(featureEnabled && this.myIsTrackingEnabled);
        this.myLastExecutedMethod = null;
        this.myLastMethodReturnValue = null;
    }

    public void setTrackingEnabled(boolean trackingEnabled) {
        this.myIsTrackingEnabled = trackingEnabled;
        this.updateRequestState(trackingEnabled && this.myFeatureEnabled);
    }

    private void updateRequestState(boolean enabled) {
        try {
            if (enabled) {
                this.myLastExecutedMethod = null;
                this.myLastMethodReturnValue = null;
                if (!this.myWatchMethodReturnValueRequest.isEnabled()) {
                    this.myWatchMethodReturnValueRequest.enable();
                }
            } else if (this.myWatchMethodReturnValueRequest.isEnabled()) {
                this.myWatchMethodReturnValueRequest.disable();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }
}

