/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public final class EvaluationContextImpl
implements EvaluationContext {
    private final Value myThisObject;
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses;

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, StackFrameProxyImpl frameProxy, Value thisObject) {
        if (suspendContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/engine/evaluation/EvaluationContextImpl.<init> must not be null");
        }
        this.myAutoLoadClasses = true;
        this.myThisObject = thisObject;
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    public Value getThisObject() {
        return this.myThisObject;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    public DebugProcessImpl getDebugProcess() {
        return this.getSuspendContext().getDebugProcess();
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess != null ? debugProcess.getProject() : null;
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        return copy;
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }
}

