/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.util.Alarm;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NotNull;

public class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.DebuggerManagerThreadImpl");
    public static final int COMMAND_TIMEOUT = 3000;
    private static final int RESTART_TIMEOUT = 500;

    DebuggerManagerThreadImpl() {
    }

    public static DebuggerManagerThreadImpl createTestInstance() {
        return new DebuggerManagerThreadImpl();
    }

    public static boolean isManagerThread() {
        return DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl;
    }

    public static void assertIsManagerThread() {
        LOG.assertTrue(DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
    }

    @Override
    public void invokeAndWait(DebuggerCommandImpl managerCommand) {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.assertTrue(!(DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
        super.invokeAndWait(managerCommand);
    }

    public void invoke(DebuggerCommandImpl managerCommand) {
        if (DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl) {
            this.processEvent(managerCommand);
        } else {
            this.schedule(managerCommand);
        }
    }

    @Override
    public void pushBack(DebuggerCommandImpl managerCommand) {
        if (this.myEvents.isClosed()) {
            managerCommand.notifyCancelled();
        } else {
            super.pushBack(managerCommand);
        }
    }

    @Override
    public void schedule(DebuggerCommandImpl managerCommand) {
        if (this.myEvents.isClosed()) {
            managerCommand.notifyCancelled();
        } else {
            super.schedule(managerCommand);
        }
    }

    public void terminateAndInvoke(DebuggerCommandImpl command, int terminateTimeout) {
        final DebuggerCommandImpl currentCommand = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.invoke(command);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (currentCommand != null) {
                    DebuggerManagerThreadImpl.this.terminateCommand(currentCommand);
                }
            }
        }, terminateTimeout);
    }

    public void terminateCommand(DebuggerCommandImpl command) {
        if (command == this.myEvents.getCurrentEvent()) {
            this.getCurrentRequest().interrupt();
            try {
                this.getCurrentRequest().join(500L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.startNewWorkerThread();
        }
    }

    public DebuggerCommandImpl getCurrentCommand() {
        return (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
    }

    @Override
    public void processEvent(@NotNull DebuggerCommandImpl managerCommand) {
        if (managerCommand == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/engine/DebuggerManagerThreadImpl.processEvent must not be null");
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEvents.isClosed()) {
                managerCommand.notifyCancelled();
            } else {
                managerCommand.run();
            }
        }
        catch (VMDisconnectedException e) {
            LOG.debug((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void startProgress(final DebuggerCommandImpl command, final ProgressWindowWithNotification progressWindow) {
        progressWindow.addListener(new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                command.release();
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        DebuggerManagerThreadImpl.this.invokeAndWait(command);
                    }
                }, (ProgressIndicator)progressWindow);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLongProcessAndFork(Runnable process) {
        this.startNewWorkerThread();
        try {
            process.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switching back to " + request);
            }
            super.invokeAndWait(new DebuggerCommandImpl(request){
                final /* synthetic */ InvokeThread.WorkerThreadRequest val$request;
                {
                    this.val$request = workerThreadRequest;
                }

                @Override
                protected void action() throws Exception {
                    DebuggerManagerThreadImpl.this.switchToRequest(this.val$request);
                }

                @Override
                protected void commandCancelled() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Event queue was closed, killing request");
                    }
                    this.val$request.interrupt();
                }
            });
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Switching back to " + request);
        }
        super.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    public void invokeCommand(final DebuggerCommand command) {
        if (command instanceof SuspendContextCommand) {
            SuspendContextCommand suspendContextCommand = (SuspendContextCommand)command;
            this.schedule(new SuspendContextCommandImpl((SuspendContextImpl)suspendContextCommand.getSuspendContext()){

                @Override
                public void contextAction() throws Exception {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        } else {
            this.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        }
    }
}

