/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.BaseValueAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

public class CompareValueWithClipboardAction
extends BaseValueAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.CompareValueWithClipboardAction");

    @Override
    protected void processText(Project project, String text) {
        DiffManager.getInstance().getDiffTool().show((DiffRequest)new ClipboardSelectionContents(text, project));
    }

    private static class ClipboardSelectionContents
    extends DiffRequest {
        private DiffContent[] myContents = null;
        private final String myValue;

        public ClipboardSelectionContents(String value, Project project) {
            super(project);
            this.myValue = value;
        }

        public String[] getContentTitles() {
            return new String[]{DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]), DebuggerBundle.message((String)"diff.content.selected.value", (Object[])new Object[0])};
        }

        public DiffContent[] getContents() {
            if (this.myContents != null) {
                return this.myContents;
            }
            DiffContent clipboardContent = ClipboardSelectionContents.createClipboardContent();
            if (clipboardContent == null) {
                return null;
            }
            this.myContents = new DiffContent[2];
            this.myContents[0] = clipboardContent;
            this.myContents[1] = new SimpleContent(this.myValue);
            return this.myContents;
        }

        public String getWindowTitle() {
            return DebuggerBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        }

        private static DiffContent createClipboardContent() {
            Transferable content = CopyPasteManager.getInstance().getContents();
            String text = "";
            try {
                text = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            return new SimpleContent(text);
        }
    }
}

