/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DebuggerInvocationUtil {
    public static void swingInvokeLater(final Project project, final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/DebuggerInvocationUtil.swingInvokeLater must not be null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project != null && !project.isDisposed()) {
                    runnable.run();
                }
            }
        });
    }

    public static void invokeLater(final Project project, final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/DebuggerInvocationUtil.invokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project != null && !project.isDisposed()) {
                    runnable.run();
                }
            }
        });
    }

    public static void invokeLater(final Project project, final @NotNull Runnable runnable, ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/DebuggerInvocationUtil.invokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project == null || project.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        }, state);
    }

    public static void invokeAndWait(final Project project, final @NotNull Runnable runnable, ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/DebuggerInvocationUtil.invokeAndWait must not be null");
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (project == null || project.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        }, state);
    }

    public static <T> T commitAndRunReadAction(Project project, final EvaluatingComputable<T> computable) throws EvaluateException {
        final Throwable[] ex = new Throwable[]{null};
        Object result = PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(new Computable<T>(){

            public T compute() {
                try {
                    return computable.compute();
                }
                catch (RuntimeException e) {
                    ex[0] = e;
                }
                catch (Exception th) {
                    ex[0] = th;
                }
                return null;
            }
        });
        if (ex[0] != null) {
            if (ex[0] instanceof RuntimeException) {
                throw (RuntimeException)ex[0];
            }
            throw (EvaluateException)ex[0];
        }
        return (T)result;
    }
}

