/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileStepBeforeRun
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.options.CompileStepBeforeRun");
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Make");
    private static final Key<RunConfiguration> RUN_CONFIGURATION = Key.create((String)"RUN_CONFIGURATION");
    @NonNls
    protected static final String MAKE_PROJECT_ON_RUN_KEY = "makeProjectOnRun";
    private final Project myProject;

    public CompileStepBeforeRun(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/options/CompileStepBeforeRun.<init> must not be null");
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    public String getDescription(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public MakeBeforeRunTask createTask(RunConfiguration runConfiguration) {
        return !(runConfiguration instanceof RemoteConfiguration) && runConfiguration instanceof RunProfileWithCompileBeforeLaunchOption ? new MakeBeforeRunTask() : null;
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        return false;
    }

    public boolean executeTask(DataContext context, final RunConfiguration configuration, MakeBeforeRunTask task) {
        if (!(configuration instanceof RunProfileWithCompileBeforeLaunchOption)) {
            return true;
        }
        final RunProfileWithCompileBeforeLaunchOption runConfiguration = (RunProfileWithCompileBeforeLaunchOption)configuration;
        final Semaphore done = new Semaphore();
        final boolean[] result = new boolean[1];
        try {
            final CompileStatusNotification callback = new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (errors == 0 && !aborted) {
                        result[0] = true;
                    }
                    done.up();
                }
            };
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CompileScope scope;
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)CompileStepBeforeRun.this.myProject);
                    if (Boolean.valueOf(System.getProperty(CompileStepBeforeRun.MAKE_PROJECT_ON_RUN_KEY, Boolean.FALSE.toString())).booleanValue()) {
                        scope = compilerManager.createProjectCompileScope(CompileStepBeforeRun.this.myProject);
                    } else {
                        Module[] modules = runConfiguration.getModules();
                        if (modules.length > 0) {
                            for (Module module : modules) {
                                if (module != null) continue;
                                LOG.error("RunConfiguration should not return null modules. Configuration=" + runConfiguration.getName() + "; class=" + runConfiguration.getClass().getName());
                            }
                            scope = compilerManager.createModulesCompileScope(modules, true);
                        } else {
                            scope = compilerManager.createProjectCompileScope(CompileStepBeforeRun.this.myProject);
                        }
                    }
                    if (!CompileStepBeforeRun.this.myProject.isDisposed()) {
                        done.down();
                        scope.putUserData(RUN_CONFIGURATION, (Object)configuration);
                        compilerManager.make(scope, callback);
                    }
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            return false;
        }
        done.waitFor();
        return result[0];
    }

    public boolean hasConfigurationButton() {
        return false;
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileContext context) {
        return (RunConfiguration)context.getCompileScope().getUserData(RUN_CONFIGURATION);
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileScope compileScope) {
        return (RunConfiguration)compileScope.getUserData(RUN_CONFIGURATION);
    }

    public static class MakeBeforeRunTask
    extends BeforeRunTask {
        private MakeBeforeRunTask() {
            this.setEnabled(true);
        }
    }
}

