/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CachingSearcher;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.cls.ClsUtil;
import java.util.Collection;

public class ChangedRetentionPolicyDependencyProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.ChangedConstantsDependencyProcessor");
    private final Project myProject;
    private final CachingSearcher mySearcher;
    private final DependencyCache myDependencyCache;

    public ChangedRetentionPolicyDependencyProcessor(Project project, CachingSearcher searcher, DependencyCache dependencyCache) {
        this.myProject = project;
        this.mySearcher = searcher;
        this.myDependencyCache = dependencyCache;
    }

    public void checkAnnotationRetentionPolicyChanges(final int annotationQName) throws CacheCorruptedException {
        Cache oldCache = this.myDependencyCache.getCache();
        if (!ClsUtil.isAnnotation((int)oldCache.getFlags(annotationQName))) {
            return;
        }
        if (!this.hasRetentionPolicyChanged(annotationQName, oldCache, this.myDependencyCache.getNewClassesCache(), this.myDependencyCache.getSymbolTable())) {
            return;
        }
        final CacheCorruptedException[] _ex = new CacheCorruptedException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiClass[] classes;
                    String qName = ChangedRetentionPolicyDependencyProcessor.this.myDependencyCache.resolve(annotationQName);
                    for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)ChangedRetentionPolicyDependencyProcessor.this.myProject).findClasses(qName.replace('$', '.'), GlobalSearchScope.allScope((Project)ChangedRetentionPolicyDependencyProcessor.this.myProject))) {
                        if (!aClass.isAnnotationType()) continue;
                        Collection<PsiReference> references = ChangedRetentionPolicyDependencyProcessor.this.mySearcher.findReferences((PsiElement)aClass, true);
                        for (PsiReference reference : references) {
                            PsiClass ownerClass = ChangedRetentionPolicyDependencyProcessor.getOwnerClass(reference.getElement());
                            if (ownerClass == null || ownerClass.equals(aClass)) continue;
                            int qualifiedName = ChangedRetentionPolicyDependencyProcessor.this.myDependencyCache.getSymbolTable().getId(ownerClass.getQualifiedName());
                            if (!ChangedRetentionPolicyDependencyProcessor.this.myDependencyCache.markClass(qualifiedName, false) || !LOG.isDebugEnabled()) continue;
                            LOG.debug("Marked dependent class " + ChangedRetentionPolicyDependencyProcessor.this.myDependencyCache.resolve(qualifiedName) + "; reason: annotation's retention policy changed from SOURCE to CLASS or RUNTIME " + ChangedRetentionPolicyDependencyProcessor.this.myDependencyCache.resolve(annotationQName));
                        }
                    }
                }
                catch (CacheCorruptedException e) {
                    _ex[0] = e;
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        });
        if (_ex[0] != null) {
            throw _ex[0];
        }
    }

    private boolean hasRetentionPolicyChanged(int annotationQName, Cache oldCache, Cache newCache, SymbolTable symbolTable) throws CacheCorruptedException {
        int oldPolicy = MakeUtil.getAnnotationRetentionPolicy(annotationQName, oldCache, symbolTable);
        int newPolicy = MakeUtil.getAnnotationRetentionPolicy(annotationQName, newCache, symbolTable);
        return oldPolicy == 1 && (newPolicy == 2 || newPolicy == 4);
    }

    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                return (PsiClass)element;
            }
            element = element.getParent();
        }
        return null;
    }
}

