/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.MapCache;
import com.intellij.util.ArrayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;

public class PackagingCompilerCache
extends MapCache<Long> {
    public PackagingCompilerCache(@NonNls String storePath) {
        super(storePath);
    }

    @Override
    public Long read(DataInputStream stream) throws IOException {
        return stream.readLong();
    }

    @Override
    public void write(Long aLong, DataOutputStream stream) throws IOException {
        stream.writeLong(aLong);
    }

    public void update(@NonNls String url, Long state) {
        if (!this.load()) {
            return;
        }
        if (state != null) {
            this.myMap.put(url, state);
            this.setDirty();
        } else {
            this.remove(url);
        }
    }

    public void remove(String url) {
        if (!this.load()) {
            return;
        }
        this.myMap.remove(url);
        this.setDirty();
    }

    public Long getState(String url) {
        if (!this.load()) {
            return null;
        }
        return (Long)this.myMap.get(url);
    }

    public String[] getUrls() {
        if (!this.load()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] urls = ArrayUtil.newStringArray((int)this.myMap.size());
        int idx = 0;
        for (String s : this.myMap.keySet()) {
            urls[idx++] = s;
        }
        return urls;
    }

    public Iterator<String> getUrlsIterator() {
        if (!this.load()) {
            return Arrays.asList(ArrayUtil.EMPTY_STRING_ARRAY).iterator();
        }
        return this.myMap.keySet().iterator();
    }
}

