/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.impl.javaCompiler.javac.JavacSettings;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class EclipseCompilerConfigurable
implements Configurable {
    private JPanel myPanel;
    private JCheckBox myCbDeprecation;
    private JCheckBox myCbDebuggingInfo;
    private JCheckBox myCbGenerateNoWarnings;
    private RawCommandLineEditor myAdditionalOptionsField;
    private JTextField myJavacMaximumHeapField;
    private final JavacSettings myCompilerSettings;

    public EclipseCompilerConfigurable(JavacSettings compilerSettings) {
        this.myCompilerSettings = compilerSettings;
        this.$$$setupUI$$$();
        this.myAdditionalOptionsField.setDialogCaption(CompilerBundle.message((String)"java.compiler.option.additional.command.line.parameters", (Object[])new Object[0]));
    }

    public String getDisplayName() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        boolean isModified = ComparingUtils.isModified(this.myJavacMaximumHeapField, this.myCompilerSettings.MAXIMUM_HEAP_SIZE);
        isModified |= ComparingUtils.isModified(this.myCbDeprecation, this.myCompilerSettings.DEPRECATION);
        isModified |= ComparingUtils.isModified(this.myCbDebuggingInfo, this.myCompilerSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myCbGenerateNoWarnings, this.myCompilerSettings.GENERATE_NO_WARNINGS);
        return isModified |= ComparingUtils.isModified(this.myAdditionalOptionsField, this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
    }

    public void apply() throws ConfigurationException {
        try {
            this.myCompilerSettings.MAXIMUM_HEAP_SIZE = Integer.parseInt(this.myJavacMaximumHeapField.getText());
            if (this.myCompilerSettings.MAXIMUM_HEAP_SIZE < 1) {
                this.myCompilerSettings.MAXIMUM_HEAP_SIZE = 128;
            }
        }
        catch (NumberFormatException exception) {
            this.myCompilerSettings.MAXIMUM_HEAP_SIZE = 128;
        }
        this.myCompilerSettings.DEPRECATION = this.myCbDeprecation.isSelected();
        this.myCompilerSettings.DEBUGGING_INFO = this.myCbDebuggingInfo.isSelected();
        this.myCompilerSettings.GENERATE_NO_WARNINGS = this.myCbGenerateNoWarnings.isSelected();
        this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING = this.myAdditionalOptionsField.getText();
    }

    public void reset() {
        this.myJavacMaximumHeapField.setText(Integer.toString(this.myCompilerSettings.MAXIMUM_HEAP_SIZE));
        this.myCbDeprecation.setSelected(this.myCompilerSettings.DEPRECATION);
        this.myCbDebuggingInfo.setSelected(this.myCompilerSettings.DEBUGGING_INFO);
        this.myCbGenerateNoWarnings.setSelected(this.myCompilerSettings.GENERATE_NO_WARNINGS);
        this.myAdditionalOptionsField.setText(this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        RawCommandLineEditor rawCommandLineEditor;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/CompilerBundle").getString("eclipse.options.group.title"), 0, 0, null, null));
        this.myCbDeprecation = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.report.deprecated"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDebuggingInfo = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.debugging.info"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateNoWarnings = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.no.warnings"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(10, 0, 0, 0), 5, 5, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.additional.command.line.parameters"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CompilerBundle").getString("javac.option.max.heap.size"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myJavacMaximumHeapField = jTextField = new JTextField();
        jTextField.setText("128");
        jTextField.setMargin(new Insets(0, 2, 0, 0));
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

