/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class TrackDependenciesScope
extends UserDataHolderBase
implements CompileScope {
    private final CompileScope myDelegate;

    public TrackDependenciesScope(CompileScope delegate) {
        this.myDelegate = delegate;
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        VirtualFile[] virtualFileArray = this.myDelegate.getFiles(fileType, inSourceOnly);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TrackDependenciesScope.getFiles must not return null");
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        return this.myDelegate.belongs(url);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] affectedModules = this.myDelegate.getAffectedModules();
        HashSet<Module> modules = new HashSet<Module>();
        for (Module module : affectedModules) {
            modules.add(module);
            TrackDependenciesScope.addDependentModules(module, modules);
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TrackDependenciesScope.getAffectedModules must not return null");
        }
        return moduleArray;
    }

    private static void addDependentModules(Module module, Collection<Module> modules) {
        Module[] dependencies;
        for (Module dependency : dependencies = ModuleRootManager.getInstance((Module)module).getDependencies()) {
            if (modules.contains(dependency)) continue;
            modules.add(dependency);
            TrackDependenciesScope.addDependentModules(dependency, modules);
        }
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TrackDependenciesScope.getUserData must not be null");
        }
        Object userData = this.myDelegate.getUserData(key);
        if (userData != null) {
            return (T)userData;
        }
        return (T)super.getUserData(key);
    }
}

