/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleCompileScope
extends FileIndexCompileScope {
    private final Project myProject;
    private final Set<Module> myScopeModules;
    private final Module[] myModules;
    private final Map<Module, String[]> myContentUrlsCache = new HashMap<Module, String[]>();

    public ModuleCompileScope(Module module, boolean includeDependentModules) {
        this.myProject = module.getProject();
        this.myScopeModules = new HashSet<Module>();
        if (includeDependentModules) {
            this.buildScopeModulesSet(module);
        } else {
            this.myScopeModules.add(module);
        }
        this.myModules = ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    public ModuleCompileScope(Project project, Module[] modules, boolean includeDependentModules) {
        this.myProject = project;
        this.myScopeModules = new HashSet<Module>();
        for (Module module : modules) {
            if (module == null) continue;
            if (includeDependentModules) {
                this.buildScopeModulesSet(module);
                continue;
            }
            this.myScopeModules.add(module);
        }
        this.myModules = ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    private void buildScopeModulesSet(Module module) {
        Module[] dependencies;
        this.myScopeModules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance((Module)module).getDependencies()) {
            if (this.myScopeModules.contains(dependency)) continue;
            this.buildScopeModulesSet(dependency);
        }
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] moduleArray = this.myScopeModules.toArray(new Module[this.myScopeModules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/ModuleCompileScope.getAffectedModules must not return null");
        }
        return moduleArray;
    }

    @Override
    protected FileIndex[] getFileIndices() {
        FileIndex[] indices = new FileIndex[this.myScopeModules.size()];
        int idx = 0;
        Iterator<Module> i$ = this.myScopeModules.iterator();
        while (i$.hasNext()) {
            Module myScopeModule;
            Module module = myScopeModule = i$.next();
            indices[idx++] = ModuleRootManager.getInstance((Module)module).getFileIndex();
        }
        return indices;
    }

    public boolean belongs(String url) {
        Module candidateModule = null;
        int maxUrlLength = 0;
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (Module module : this.myModules) {
            String[] contentRootUrls;
            for (final String contentRootUrl : contentRootUrls = this.getModuleContentUrls(module)) {
                if (contentRootUrl.length() < maxUrlLength || !ModuleCompileScope.isUrlUnderRoot(url, contentRootUrl)) continue;
                if (contentRootUrl.length() == maxUrlLength) {
                    if (candidateModule == null) {
                        candidateModule = module;
                        continue;
                    }
                    if (candidateModule.equals(module)) continue;
                    candidateModule = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

                        public Module compute() {
                            VirtualFile contentRootFile = VirtualFileManager.getInstance().findFileByUrl(contentRootUrl);
                            if (contentRootFile != null) {
                                return projectFileIndex.getModuleForFile(contentRootFile);
                            }
                            return null;
                        }
                    });
                    continue;
                }
                maxUrlLength = contentRootUrl.length();
                candidateModule = module;
            }
        }
        if (candidateModule != null && this.myScopeModules.contains(candidateModule)) {
            String[] sourceRootUrls;
            String[] excludeRootUrls;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(candidateModule);
            for (String excludeRootUrl : excludeRootUrls = moduleRootManager.getExcludeRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, excludeRootUrl)) continue;
                return false;
            }
            for (String sourceRootUrl : sourceRootUrls = moduleRootManager.getSourceRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, sourceRootUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUrlUnderRoot(String url, String root) {
        return url.length() > root.length() && url.charAt(root.length()) == '/' && FileUtil.startsWith((String)url, (String)root);
    }

    private String[] getModuleContentUrls(Module module) {
        String[] contentRootUrls = this.myContentUrlsCache.get(module);
        if (contentRootUrls == null) {
            contentRootUrls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            this.myContentUrlsCache.put(module, contentRootUrls);
        }
        return contentRootUrls;
    }
}

