/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionFix;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionForClassFix;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.options.CompilerConfigurable;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerErrorTreeView
extends NewErrorTreeViewPanel {
    public CompilerErrorTreeView(Project project, Runnable rerunAction) {
        super(project, "reference.toolWindows.messages", true, true, rerunAction);
    }

    @Override
    protected void fillRightToolbarGroup(DefaultActionGroup group) {
        super.fillRightToolbarGroup(group);
        group.add((AnAction)new CompilerPropertiesAction());
    }

    @Override
    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
        group.add((AnAction)new ExcludeFromCompileAction());
        group.addSeparator();
        group.add((AnAction)new SuppressJavacWarningsAction());
        group.add((AnAction)new SuppressJavacWarningForClassAction());
        group.addSeparator();
        ActionGroup popupGroup = (ActionGroup)ActionManager.getInstance().getAction("CompilerErrorViewPopupMenu");
        if (popupGroup != null) {
            for (AnAction action : popupGroup.getChildren(null)) {
                group.add(action);
            }
        }
    }

    @Override
    protected boolean shouldShowFirstErrorInEditor() {
        return CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).AUTO_SHOW_ERRORS_IN_EDITOR;
    }

    private class SuppressJavacWarningForClassAction
    extends SuppressJavacWarningsAction {
        private SuppressJavacWarningForClassAction() {
        }

        @Override
        protected AddSuppressInspectionFix getSuppressAction(String id) {
            return new AddSuppressInspectionForClassFix(id){

                @Override
                protected boolean use15Suppressions(PsiDocCommentOwner container) {
                    return true;
                }
            };
        }
    }

    private class SuppressJavacWarningsAction
    extends AnAction {
        private SuppressJavacWarningsAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            NavigatableMessageElement messageElement = (NavigatableMessageElement)CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            String[] text = messageElement.getText();
            String id = text[0].substring(1, text[0].indexOf("]"));
            final AddSuppressInspectionFix suppressInspectionFix = this.getSuppressAction(id);
            final Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            assert (project != null);
            final OpenFileDescriptor navigatable = (OpenFileDescriptor)messageElement.getNavigatable();
            final PsiFile file = PsiManager.getInstance((Project)project).findFile(navigatable.getFile());
            assert (file != null);
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                suppressInspectionFix.invoke(project, null, file.findElementAt(navigatable.getOffset()));
                            }
                            catch (IncorrectOperationException e1) {
                                LOG.error((Throwable)e1);
                            }
                        }
                    });
                }
            }, suppressInspectionFix.getText(), null);
        }

        public void update(AnActionEvent e) {
            NavigatableMessageElement messageElement;
            String[] text;
            Presentation presentation = e.getPresentation();
            presentation.setVisible(false);
            presentation.setEnabled(false);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            ErrorTreeElement errorTreeElement = CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            if (errorTreeElement instanceof NavigatableMessageElement && (text = (messageElement = (NavigatableMessageElement)errorTreeElement).getText()).length > 0 && text[0].startsWith("[") && text[0].indexOf("]") != -1) {
                presentation.setVisible(true);
                Navigatable navigatable = messageElement.getNavigatable();
                if (navigatable instanceof OpenFileDescriptor) {
                    boolean is_1_5;
                    OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)navigatable;
                    VirtualFile virtualFile = fileDescriptor.getFile();
                    Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                    if (module == null) {
                        return;
                    }
                    Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (jdk == null) {
                        return;
                    }
                    boolean bl = is_1_5 = JavaSdk.getInstance().compareTo(jdk.getVersionString(), "1.5") >= 0;
                    if (!is_1_5) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile == null) {
                        return;
                    }
                    if (LanguageLevelUtil.getEffectiveLanguageLevel((Module)module).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                        return;
                    }
                    PsiElement context = psiFile.findElementAt(fileDescriptor.getOffset());
                    if (context == null) {
                        return;
                    }
                    String id = text[0].substring(1, text[0].indexOf("]"));
                    AddSuppressInspectionFix suppressInspectionFix = this.getSuppressAction(id);
                    boolean available = suppressInspectionFix.isAvailable(project, null, context);
                    presentation.setEnabled(available);
                    if (available) {
                        presentation.setText(suppressInspectionFix.getText());
                    }
                }
            }
        }

        protected AddSuppressInspectionFix getSuppressAction(String id) {
            return new AddSuppressInspectionFix(id){

                @Override
                public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement context) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$2.isAvailable must not be null");
                    }
                    if (this.getContainer(context) instanceof PsiClass) {
                        return false;
                    }
                    return super.isAvailable(project, editor, context);
                }

                @Override
                protected boolean use15Suppressions(PsiDocCommentOwner container) {
                    return true;
                }
            };
        }
    }

    private class ExcludeFromCompileAction
    extends AnAction {
        public ExcludeFromCompileAction() {
            super(CompilerBundle.message((String)"actions.exclude.from.compile.text", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile file = this.getSelectedFile();
            if (file != null && file.isValid()) {
                ExcludeEntryDescription description = new ExcludeEntryDescription(file, false, true, (Disposable)CompilerErrorTreeView.this.myProject);
                ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)CompilerErrorTreeView.this.myProject)).getExcludedEntriesConfiguration().addExcludeEntryDescription(description);
                FileStatusManager.getInstance((Project)CompilerErrorTreeView.this.myProject).fileStatusesChanged();
            }
        }

        private VirtualFile getSelectedFile() {
            ErrorTreeElement selectedElement = CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            if (selectedElement == null) {
                return null;
            }
            String filePresentableText = this.getSelectedFilePresentableText(selectedElement);
            if (filePresentableText == null) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(filePresentableText.replace('\\', '/'));
        }

        private String getSelectedFilePresentableText(ErrorTreeElement selectedElement) {
            String filePresentableText = null;
            if (selectedElement instanceof GroupingElement) {
                GroupingElement groupingElement = (GroupingElement)selectedElement;
                filePresentableText = groupingElement.getName();
            } else {
                ErrorTreeNodeDescriptor treeNodeDescriptor;
                ErrorTreeElement element;
                NodeDescriptor parentDescriptor = CompilerErrorTreeView.this.getSelectedNodeDescriptor().getParentDescriptor();
                if (parentDescriptor instanceof ErrorTreeNodeDescriptor && (element = (treeNodeDescriptor = (ErrorTreeNodeDescriptor)parentDescriptor).getElement()) instanceof GroupingElement) {
                    GroupingElement groupingElement = (GroupingElement)element;
                    filePresentableText = groupingElement.getName();
                }
            }
            return filePresentableText;
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            boolean isApplicable = this.getSelectedFile() != null;
            presentation.setEnabled(isApplicable);
            presentation.setVisible(isApplicable);
        }
    }

    private static class CompilerPropertiesAction
    extends AnAction {
        private static final Icon ICON_OPTIONS = IconLoader.getIcon((String)"/general/ideOptions.png");

        public CompilerPropertiesAction() {
            super(CompilerBundle.message((String)"action.compiler.properties.text", (Object[])new Object[0]), null, ICON_OPTIONS);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)CompilerConfigurable.getInstance(project));
        }
    }
}

