/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CompilerCacheManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerCacheManager");
    private final Map<Compiler, Object> myCompilerToCacheMap = new HashMap<Compiler, Object>();
    private final List<Disposable> myCacheDisposables = new ArrayList<Disposable>();
    private final File myCachesRoot;
    private final Runnable myShutdownTask = new Runnable(){

        @Override
        public void run() {
            CompilerCacheManager.this.flushCaches();
        }
    };

    public CompilerCacheManager(Project project) {
        this.myCachesRoot = CompilerPaths.getCacheStoreDirectory((Project)project);
    }

    public static CompilerCacheManager getInstance(Project project) {
        return (CompilerCacheManager)project.getComponent(CompilerCacheManager.class);
    }

    public void projectOpened() {
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutdownTask);
    }

    public void projectClosed() {
        ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutdownTask);
        this.flushCaches();
    }

    @NotNull
    public String getComponentName() {
        if ("CompilerCacheManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompilerCacheManager.getComponentName must not return null");
        }
        return "CompilerCacheManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.flushCaches();
    }

    private File getCompilerRootDir(Compiler compiler) {
        File dir = new File(this.myCachesRoot, CompilerCacheManager.getCompilerIdString(compiler));
        dir.mkdirs();
        return dir;
    }

    public synchronized FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        Object cache = this.myCompilerToCacheMap.get(compiler);
        if (cache == null) {
            final FileProcessingCompilerStateCache stateCache = new FileProcessingCompilerStateCache(this.getCompilerRootDir((Compiler)compiler), (ValidityStateFactory)compiler);
            this.myCompilerToCacheMap.put((Compiler)compiler, stateCache);
            this.myCacheDisposables.add(new Disposable(){

                public void dispose() {
                    stateCache.close();
                }
            });
            cache = stateCache;
        } else {
            LOG.assertTrue(cache instanceof FileProcessingCompilerStateCache);
        }
        return (FileProcessingCompilerStateCache)cache;
    }

    public synchronized StateCache<ValidityState> getGeneratingCompilerCache(final GeneratingCompiler compiler) throws IOException {
        Object cache = this.myCompilerToCacheMap.get(compiler);
        if (cache == null) {
            File cacheDir = this.getCompilerRootDir((Compiler)compiler);
            final StateCache<ValidityState> stateCache = new StateCache<ValidityState>(new File(cacheDir, "timestamps")){

                @Override
                public ValidityState read(DataInput stream) throws IOException {
                    return compiler.createValidityState(stream);
                }

                @Override
                public void write(ValidityState validityState, DataOutput out) throws IOException {
                    validityState.save(out);
                }
            };
            this.myCompilerToCacheMap.put((Compiler)compiler, stateCache);
            this.myCacheDisposables.add(new Disposable(){

                public void dispose() {
                    try {
                        stateCache.close();
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            });
            cache = stateCache;
        }
        return (StateCache)cache;
    }

    public static String getCompilerIdString(Compiler compiler) {
        String description = compiler.getDescription();
        return description.replaceAll("\\s+", "_").replaceAll("[\\.\\?]", "_").toLowerCase();
    }

    private synchronized void flushCaches() {
        for (Disposable disposable : this.myCacheDisposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        this.myCacheDisposables.clear();
        this.myCompilerToCacheMap.clear();
    }

    public void clearCaches(CompileContext context) {
        this.flushCaches();
        File[] children = this.myCachesRoot.listFiles();
        if (children != null) {
            for (File child : children) {
                boolean deleteOk = FileUtil.delete((File)child);
                if (deleteOk) continue;
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{child.getPath()}), null, -1, -1);
            }
        }
    }
}

