/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ConstantValueArray
extends ConstantValue {
    private final ConstantValue[] myValue;

    public ConstantValueArray(ConstantValue[] value) {
        this.myValue = value;
    }

    public ConstantValueArray(DataInput in) throws IOException {
        int size = in.readInt();
        this.myValue = new ConstantValue[size];
        for (int idx = 0; idx < size; ++idx) {
            this.myValue[idx] = MemberInfoExternalizer.loadConstantValue(in);
        }
    }

    public ConstantValue[] getValue() {
        return this.myValue;
    }

    @Override
    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myValue.length);
        for (int idx = 0; idx < this.myValue.length; ++idx) {
            MemberInfoExternalizer.saveConstantValue(out, this.myValue[idx]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantValueArray)) {
            return false;
        }
        ConstantValueArray constantValueArray = (ConstantValueArray)o;
        return Arrays.equals(this.myValue, constantValueArray.myValue);
    }

    public int hashCode() {
        return 0;
    }
}

