/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inconsistentLanguageLevel;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InconsistentLanguageLevelInspection
extends DescriptorProviderInspection {
    private static final Logger LOGGER = Logger.getInstance((String)("#" + InconsistentLanguageLevelInspection.class.getName()));

    @Override
    public void runInspection(AnalysisScope scope, InspectionManager manager) {
        final HashSet modules = new HashSet();
        scope.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
                if (module != null) {
                    modules.add(module);
                }
            }
        });
        if (!modules.isEmpty()) {
            LanguageLevel projectLanguageLevel = LanguageLevelProjectExtension.getInstance((Project)((Module)modules.iterator().next()).getProject()).getLanguageLevel();
            for (Module module : modules) {
                LanguageLevel languageLevel = LanguageLevelModuleExtension.getInstance((Module)module).getLanguageLevel();
                if (languageLevel == null) {
                    languageLevel = projectLanguageLevel;
                }
                LOGGER.assertTrue(languageLevel != null);
                RefModule refModule = this.getRefManager().getRefModule(module);
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    Module dependantModule;
                    if (!(entry instanceof ModuleOrderEntry) || (dependantModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                    LanguageLevel dependantLanguageLevel = LanguageLevelModuleExtension.getInstance((Module)dependantModule).getLanguageLevel();
                    if (dependantLanguageLevel == null) {
                        dependantLanguageLevel = projectLanguageLevel;
                    }
                    LOGGER.assertTrue(dependantLanguageLevel != null);
                    if (languageLevel.compareTo((Enum)dependantLanguageLevel) >= 0) continue;
                    CommonProblemDescriptor problemDescriptor = manager.createProblemDescriptor("Inconsistent language level settings: module " + module.getName() + " with language level " + languageLevel + " depends on module " + dependantModule.getName() + " with language level " + dependantLanguageLevel, new QuickFix[]{new UnnecessaryModuleDependencyInspection.RemoveModuleDependencyFix(module, dependantModule), new OpenModuleSettingsFix(module)});
                    this.addProblemElement((RefEntity)refModule, problemDescriptor);
                }
            }
        }
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        if (JobDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection.getJobDescriptors must not return null");
        }
        return JobDescriptor.EMPTY_ARRAY;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.MODULARIZATION_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        if ("Inconsistent language level settings" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection.getDisplayName must not return null");
        }
        return "Inconsistent language level settings";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("InconsistentLanguageLevel" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection.getShortName must not return null");
        }
        return "InconsistentLanguageLevel";
    }

    private static class OpenModuleSettingsFix
    implements QuickFix {
        private Module myModule;

        private OpenModuleSettingsFix(Module module) {
            this.myModule = module;
        }

        @NotNull
        public String getName() {
            String string = "Open module " + this.myModule.getName() + " settings";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection$OpenModuleSettingsFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection$OpenModuleSettingsFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection$OpenModuleSettingsFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection$OpenModuleSettingsFix.applyFix must not be null");
            }
            if (!this.myModule.isDisposed()) {
                ProjectSettingsService.getInstance(project).showModuleConfigurationDialog(this.myModule.getName(), ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]), false);
            }
        }
    }
}

