/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null || !psiElement.isValid() || !(psiElement instanceof XmlToken)) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(psiElement);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.doFix must not be null");
        }
        XmlToken endNameToken = (XmlToken)element;
        PsiElement tagElement = endNameToken.getParent();
        if (!(tagElement instanceof XmlTag) && !(tagElement instanceof PsiErrorElement)) {
            return;
        }
        if (tagElement instanceof PsiErrorElement) {
            tagElement.delete();
        } else {
            Document document;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(tagElement.getContainingFile())) != null) {
                document.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction.applyFix must not be null");
        }
        final PsiElement element = descriptor.getPsiElement();
        if (!element.isValid() || !(element instanceof XmlToken)) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                RemoveExtraClosingTagIntentionAction.doFix(element);
            }
        }.execute();
    }
}

