/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class RemoveAttributeIntentionAction
implements LocalQuickFix {
    private final String myLocalName;
    private final XmlAttribute myAttribute;

    public RemoveAttributeIntentionAction(String localName, XmlAttribute attribute) {
        this.myLocalName = localName;
        this.myAttribute = attribute;
    }

    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction.applyFix must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myAttribute.getContainingFile())) {
            return;
        }
        PsiElement next = RemoveAttributeIntentionAction.findNextAttribute(this.myAttribute);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                RemoveAttributeIntentionAction.this.myAttribute.delete();
            }
        }.execute();
    }

    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }
}

