/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomTagOrAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspection
extends HtmlUnknownTagInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownAttributeInspection");
    @NonNls
    public static final String ATTRIBUTE_SHORT_NAME = "HtmlUnknownAttribute";

    public HtmlUnknownAttributeInspection() {
        super("");
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.attribute", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if (ATTRIBUTE_SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.getShortName must not return null");
        }
        return ATTRIBUTE_SHORT_NAME;
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    protected String getPanelTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.getLogger must not return null");
        }
        return logger;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.checkTag must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.checkTag must not be null");
        }
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (attribute == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.checkAttribute must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspection.checkAttribute must not be null");
        }
        XmlTag tag = attribute.getParent();
        if (tag instanceof HtmlTag) {
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
            String name = attribute.getName();
            if (!(attributeDescriptor != null || attribute.isNamespaceDeclaration() || XmlUtil.attributeFromTemplateFramework(name, tag) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                ASTNode node = attribute.getNode();
                assert (node != null);
                PsiElement nameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node).getPsi();
                holder.registerProblem(nameElement, XmlErrorMessages.message("attribute.is.not.allowed.here", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddCustomTagOrAttributeIntentionAction(this.getShortName(), name, 2), new RemoveAttributeIntentionAction(name, attribute)});
            }
        }
    }
}

