/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;

public class InspectionProfileWrapper {
    private final InspectionProfileImpl myProfile;

    public InspectionProfileWrapper(InspectionProfile profile) {
        this.myProfile = (InspectionProfileImpl)profile;
    }

    public InspectionTool[] getInspectionTools(PsiElement element) {
        return (InspectionTool[])this.myProfile.getInspectionTools(element);
    }

    public List<LocalInspectionTool> getHighlightingLocalInspectionTools(PsiElement element) {
        InspectionTool[] tools;
        ArrayList<LocalInspectionTool> enabled = new ArrayList<LocalInspectionTool>();
        for (InspectionTool tool : tools = this.getInspectionTools(element)) {
            if (!(tool instanceof LocalInspectionToolWrapper) || !this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)tool.getShortName()), element)) continue;
            enabled.add(((LocalInspectionToolWrapper)tool).getTool());
        }
        return enabled;
    }

    public String getName() {
        return this.myProfile.getName();
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        return this.myProfile.isToolEnabled(key, element);
    }

    public boolean isToolEnabled(HighlightDisplayKey key) {
        return this.myProfile.isToolEnabled(key);
    }

    public InspectionTool getInspectionTool(String shortName, PsiElement element) {
        return (InspectionTool)this.myProfile.getInspectionTool(shortName, element);
    }

    public void init(Project project) {
        List<ToolsImpl> profileEntries = this.myProfile.getAllEnabledInspectionTools();
        for (ToolsImpl profileEntry : profileEntries) {
            for (ScopeToolState toolState : profileEntry.getTools()) {
                toolState.getTool().projectOpened(project);
            }
        }
    }

    public void cleanup(Project project) {
        this.myProfile.cleanup(project);
    }

    public InspectionProfile getInspectionProfile() {
        return this.myProfile;
    }
}

