/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="EntryPointsManager", storages={@Storage(id="default", file="$PROJECT_FILE$")})
public class EntryPointsManagerImpl
implements PersistentStateComponent<Element>,
EntryPointsManager,
Disposable {
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints;
    private final Set<RefElement> myTemporaryEntryPoints;
    private static final String VERSION = "2.0";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    private boolean myAddNonJavaEntries = true;
    private boolean myResolved = false;
    private final Project myProject;
    private long myLastModificationCount = -1L;

    public EntryPointsManagerImpl(Project project) {
        this.myProject = project;
        this.myTemporaryEntryPoints = new HashSet<RefElement>();
        this.myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
    }

    public static EntryPointsManagerImpl getInstance(Project project) {
        return (EntryPointsManagerImpl)ServiceManager.getService((Project)project, EntryPointsManagerImpl.class);
    }

    public void loadState(Element element) {
        Element entryPointsElement = element.getChild("entry_points");
        String version = entryPointsElement.getAttributeValue(VERSION_ATTR);
        if (!Comparing.strEqual((String)version, (String)VERSION)) {
            this.convert(entryPointsElement);
        } else {
            List content = entryPointsElement.getChildren();
            for (Object aContent : content) {
                Element entryElement = (Element)aContent;
                if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
                SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(entryElement);
                this.myPersistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
            }
        }
    }

    public Element getState() {
        Element element = new Element("state");
        this.writeExternal(element);
        return element;
    }

    public void writeExternal(Element element) {
        Element entryPointsElement = new Element("entry_points");
        entryPointsElement.setAttribute(VERSION_ATTR, VERSION);
        for (SmartRefElementPointer entryPoint : this.myPersistentEntryPoints.values()) {
            assert (entryPoint.isPersistent());
            entryPoint.writeExternal(entryPointsElement);
        }
        element.addContent(entryPointsElement);
    }

    public void resolveEntryPoints(final RefManager manager) {
        if (!this.myResolved) {
            this.myResolved = true;
            this.validateEntryPoints();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (SmartRefElementPointer entryPoint : EntryPointsManagerImpl.this.myPersistentEntryPoints.values()) {
                        if (!entryPoint.resolve(manager)) continue;
                        RefEntity refElement = entryPoint.getRefElement();
                        ((RefElementImpl)refElement).setEntry(true);
                        ((RefElementImpl)refElement).setPermanentEntry(entryPoint.isPersistent());
                    }
                }
            });
        }
    }

    private void purgeTemporaryEntryPoints() {
        for (RefElement entryPoint : this.myTemporaryEntryPoints) {
            ((RefElementImpl)entryPoint).setEntry(false);
        }
        this.myTemporaryEntryPoints.clear();
    }

    public void addEntryPoint(RefElement newEntryPoint, boolean isPersistent) {
        if (!newEntryPoint.isValid()) {
            return;
        }
        if (newEntryPoint instanceof RefClass) {
            RefClass refClass = (RefClass)newEntryPoint;
            if (refClass.isAnonymous()) {
                return;
            }
            ArrayList refConstructors = refClass.getConstructors();
            if (refConstructors.size() == 1) {
                this.addEntryPoint((RefElement)refConstructors.get(0), isPersistent);
                return;
            }
            if (refConstructors.size() > 1) {
                for (int i = 0; i < refConstructors.size(); ++i) {
                    this.addEntryPoint((RefElement)((RefMethod)refConstructors.get(i)), isPersistent);
                }
                return;
            }
        }
        if (isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else if (this.myPersistentEntryPoints.get(newEntryPoint.getExternalName()) == null) {
            EntryPointsManagerImpl entryPointsManager;
            SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl((RefEntity)newEntryPoint, true);
            this.myPersistentEntryPoints.put(entry.getFQName(), entry);
            ((RefElementImpl)newEntryPoint).setEntry(true);
            ((RefElementImpl)newEntryPoint).setPermanentEntry(true);
            if (entry.isPersistent() && this != (entryPointsManager = EntryPointsManagerImpl.getInstance(newEntryPoint.getElement().getProject()))) {
                entryPointsManager.addEntryPoint(newEntryPoint, true);
            }
        }
    }

    public void removeEntryPoint(RefElement anEntryPoint) {
        Project project;
        EntryPointsManagerImpl entryPointsManager;
        RefClass refClass;
        if (anEntryPoint instanceof RefClass && !(refClass = (RefClass)anEntryPoint).isInterface()) {
            anEntryPoint = refClass.getDefaultConstructor();
        }
        if (anEntryPoint == null) {
            return;
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        Set<Map.Entry<String, SmartRefElementPointer>> set = this.myPersistentEntryPoints.entrySet();
        String key = null;
        for (Map.Entry<String, SmartRefElementPointer> entry : set) {
            SmartRefElementPointer value = entry.getValue();
            if (value.getRefElement() != anEntryPoint) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.myPersistentEntryPoints.remove(key);
            ((RefElementImpl)anEntryPoint).setEntry(false);
        }
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid() && this != (entryPointsManager = EntryPointsManagerImpl.getInstance(project = anEntryPoint.getElement().getProject()))) {
            entryPointsManager.removeEntryPoint(anEntryPoint);
        }
    }

    public RefElement[] getEntryPoints() {
        this.validateEntryPoints();
        ArrayList<RefElement> entries = new ArrayList<RefElement>();
        Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer refElementPointer : collection) {
            RefEntity elt = refElementPointer.getRefElement();
            if (!(elt instanceof RefElement)) continue;
            entries.add((RefElement)elt);
        }
        entries.addAll(this.myTemporaryEntryPoints);
        return entries.toArray(new RefElement[entries.size()]);
    }

    public void dispose() {
        this.cleanup();
    }

    private void validateEntryPoints() {
        long count = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (count != this.myLastModificationCount) {
            SmartRefElementPointer[] entries;
            this.myLastModificationCount = count;
            Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
            for (SmartRefElementPointer entry : entries = collection.toArray(new SmartRefElementPointer[collection.size()])) {
                RefElement refElement = (RefElement)entry.getRefElement();
                if (refElement == null || refElement.isValid()) continue;
                this.myPersistentEntryPoints.remove(entry.getFQName());
            }
            Iterator<RefElement> it = this.myTemporaryEntryPoints.iterator();
            while (it.hasNext()) {
                RefElement refElement = it.next();
                if (refElement.isValid()) continue;
                it.remove();
            }
        }
    }

    public void cleanup() {
        this.purgeTemporaryEntryPoints();
        Collection<SmartRefElementPointer> entries = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer entry : entries) {
            entry.freeReference();
        }
    }

    public boolean isAddNonJavaEntries() {
        return this.myAddNonJavaEntries;
    }

    public void addAllPersistentEntries(EntryPointsManagerImpl manager) {
        this.myPersistentEntryPoints.putAll(manager.myPersistentEntryPoints);
    }

    public void convert(Element element) {
        List content = element.getChildren();
        for (Object aContent : content) {
            Element entryElement = (Element)aContent;
            if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
            String fqName = entryElement.getAttributeValue("FQNAME");
            String type = entryElement.getAttributeValue("TYPE");
            if (Comparing.strEqual((String)type, (String)"method")) {
                int spaceIdx = fqName.indexOf(32);
                int lastDotIdx = fqName.lastIndexOf(46);
                boolean notype = false;
                int parenIndex = fqName.indexOf(40);
                while (lastDotIdx > parenIndex) {
                    lastDotIdx = fqName.lastIndexOf(46, lastDotIdx - 1);
                }
                if (spaceIdx < 0 || spaceIdx + 1 > lastDotIdx || spaceIdx > parenIndex) {
                    notype = true;
                }
                String className = fqName.substring(notype ? 0 : spaceIdx + 1, lastDotIdx);
                String methodSignature = notype ? fqName.substring(lastDotIdx + 1) : fqName.substring(0, spaceIdx) + ' ' + fqName.substring(lastDotIdx + 1);
                fqName = className + " " + methodSignature;
            } else if (Comparing.strEqual((String)type, (String)"field")) {
                int lastDotIdx = fqName.lastIndexOf(46);
                if (lastDotIdx <= 0 || lastDotIdx >= fqName.length() - 2) continue;
                String className = fqName.substring(0, lastDotIdx);
                String fieldName = fqName.substring(lastDotIdx + 1);
                fqName = className + " " + fieldName;
            }
            SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(type, fqName);
            this.myPersistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
        }
    }

    public void setAddNonJavaEntries(boolean addNonJavaEntries) {
        this.myAddNonJavaEntries = addNonJavaEntries;
    }
}

