/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaNotNullValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;

public class DfaValueFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.value.DfaValueFactory");
    private int myLastID = 0;
    private final TIntObjectHashMap<DfaValue> myValues = new TIntObjectHashMap();
    private final DfaVariableValue.Factory myVarFactory = new DfaVariableValue.Factory(this);
    private final DfaConstValue.Factory myConstFactory = new DfaConstValue.Factory(this);
    private final DfaBoxedValue.Factory myBoxedFactory = new DfaBoxedValue.Factory(this);
    private final DfaNotNullValue.Factory myNotNullFactory = new DfaNotNullValue.Factory(this);
    private final DfaTypeValue.Factory myTypeFactory = new DfaTypeValue.Factory(this);
    private final DfaRelationValue.Factory myRelationFactory = new DfaRelationValue.Factory(this);

    int createID() {
        ++this.myLastID;
        LOG.assertTrue(this.myLastID >= 0, (Object)"Overflow");
        return this.myLastID;
    }

    void registerValue(DfaValue value) {
        this.myValues.put(value.getID(), (Object)value);
    }

    public DfaValue getValue(int id) {
        return (DfaValue)this.myValues.get(id);
    }

    public DfaValue create(PsiExpression psiExpression) {
        DfaValue result = null;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement psiSource = ((PsiReferenceExpression)psiExpression).resolve();
            if (psiSource != null) {
                PsiVariable psiVariable;
                if (psiSource instanceof PsiVariable) {
                    PsiType type;
                    PsiExpression initializer;
                    PsiVariable variable = (PsiVariable)psiSource;
                    DfaValue constValue = this.getConstFactory().create(variable);
                    if (constValue != null) {
                        return constValue;
                    }
                    if (!(psiSource instanceof PsiField) && (initializer = variable.getInitializer()) instanceof PsiBinaryExpression && variable.hasModifierProperty("final") && (type = initializer.getType()) != null && type.equalsToText("java.lang.String")) {
                        return this.getNotNullFactory().create(type);
                    }
                }
                if ((psiVariable = DfaValueFactory.resolveVariable((PsiReferenceExpression)psiExpression)) != null) {
                    result = this.getVarFactory().create(psiVariable, false);
                }
            }
        } else if (psiExpression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)psiExpression;
            result = literal.getValue() instanceof String ? this.getNotNullFactory().create(psiExpression.getType()) : this.getConstFactory().create(literal);
        } else if (psiExpression instanceof PsiNewExpression) {
            result = this.getNotNullFactory().create(psiExpression.getType());
        } else {
            Object value = JavaConstantExpressionEvaluator.computeConstantExpression(psiExpression, false);
            PsiType type = psiExpression.getType();
            if (value != null && type != null) {
                result = value instanceof String ? this.getNotNullFactory().create(type) : this.getConstFactory().createFromValue(value, type);
            }
        }
        return result;
    }

    public static PsiVariable resolveVariable(PsiReferenceExpression refExpression) {
        PsiElement resolved;
        PsiExpression qualifier = refExpression.getQualifierExpression();
        if ((qualifier == null || qualifier instanceof PsiThisExpression) && (resolved = refExpression.resolve()) instanceof PsiVariable) {
            return (PsiVariable)resolved;
        }
        return null;
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getVarFactory must not return null");
        }
        return factory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        DfaConstValue.Factory factory = this.myConstFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getConstFactory must not return null");
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getBoxedFactory must not return null");
        }
        return factory;
    }

    @NotNull
    public DfaNotNullValue.Factory getNotNullFactory() {
        DfaNotNullValue.Factory factory = this.myNotNullFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getNotNullFactory must not return null");
        }
        return factory;
    }

    @NotNull
    public DfaTypeValue.Factory getTypeFactory() {
        DfaTypeValue.Factory factory = this.myTypeFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getTypeFactory must not return null");
        }
        return factory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        DfaRelationValue.Factory factory = this.myRelationFactory;
        if (factory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaValueFactory.getRelationFactory must not return null");
        }
        return factory;
    }
}

