/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    private final DfaValue myWrappedValue;

    private DfaBoxedValue(DfaValue valueToWrap, DfaValueFactory factory) {
        super(factory);
        this.myWrappedValue = valueToWrap;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    public DfaValue getWrappedValue() {
        return this.myWrappedValue;
    }

    public static class Factory {
        private final Map<Object, DfaBoxedValue> cachedValues = new HashMap();
        private final Map<Object, DfaBoxedValue> cachedNegatedValues = new HashMap();
        private final DfaValueFactory myFactory;
        private final Map<PsiVariable, DfaUnboxedValue> cachedUnboxedValues = new THashMap();
        private final Map<PsiVariable, DfaUnboxedValue> cachedNegatedUnboxedValues = new THashMap();

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap) {
            Object o;
            if (valueToWrap instanceof DfaUnboxedValue) {
                return ((DfaUnboxedValue)valueToWrap).getVariable();
            }
            Object object = valueToWrap instanceof DfaConstValue ? ((DfaConstValue)valueToWrap).getValue() : (o = valueToWrap instanceof DfaVariableValue ? ((DfaVariableValue)valueToWrap).getPsiVariable() : null);
            if (o == null) {
                return null;
            }
            Map<Object, DfaBoxedValue> map = valueToWrap instanceof DfaVariableValue && ((DfaVariableValue)valueToWrap).isNegated() ? this.cachedNegatedValues : this.cachedValues;
            DfaBoxedValue boxedValue = map.get(o);
            if (boxedValue == null) {
                boxedValue = new DfaBoxedValue(valueToWrap, this.myFactory);
                map.put(o, boxedValue);
            }
            return boxedValue;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public DfaValue createUnboxed(DfaValue value) {
            void var2_8;
            DfaValue dfaValue;
            if (value instanceof DfaBoxedValue) {
                dfaValue = ((DfaBoxedValue)value).getWrappedValue();
                if (dfaValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaBoxedValue$Factory.createUnboxed must not return null");
                return dfaValue;
            }
            if (value instanceof DfaConstValue) {
                if (!(value == value.myFactory.getConstFactory().getNull() ? (dfaValue = DfaUnknownValue.getInstance()) != null : (dfaValue = value) != null)) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaBoxedValue$Factory.createUnboxed must not return null");
                return dfaValue;
            }
            if (value instanceof DfaVariableValue) {
                PsiVariable var = ((DfaVariableValue)value).getPsiVariable();
                Map<PsiVariable, DfaUnboxedValue> map = ((DfaVariableValue)value).isNegated() ? this.cachedNegatedUnboxedValues : this.cachedUnboxedValues;
                DfaValue dfaValue2 = map.get(var);
                if (dfaValue2 == null) {
                    DfaUnboxedValue dfaUnboxedValue = new DfaUnboxedValue((DfaVariableValue)value, this.myFactory);
                    map.put(var, dfaUnboxedValue);
                }
            } else {
                DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            }
            if ((dfaValue = var2_8) != null) return dfaValue;
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaBoxedValue$Factory.createUnboxed must not return null");
        }
    }
}

